//  This class displays the current RTP Session
//  participants
package CamClnt;

import java.awt.*;
import java.util.Enumeration;
import javax.media.rtp.session.*;


public class ParticipantList extends Frame {

    List participants;
    final static int ACTIVE = 1;
    final static int PASSIVE = 2;


    ParticipantList( String address, int port, int ttl, String media ) {
	super( (String)(media + ":" + address + "/" + port + "/" + ttl));
	participants = new List( 4, false );
	add( participants );
	pack();
	setLocation( 60, 100 );
	if( participants.getItemCount() > 0 )
	  show();
    }

    protected int findListItem( String name ) {
	for( int i = 0; i < participants.getItemCount(); i++ ) {
	    if( (participants.getItem(i)).equals( name )) {
		return i;
	    }
	}
	return -1;
    }
    
    public void updateList( Enumeration newpart ) {
	while( newpart.hasMoreElements() ) {
	    RTPParticipant cur = (RTPParticipant)newpart.nextElement();
	    if( findListItem( cur.getCNAME() ) == -1 ) {
		participants.addItem( cur.getCNAME() );
	    }
	}
    }

    public void removeListItem( String name ) {
	participants.delItem( findListItem( name ) );
    }

    public void addListItem( String name ) {
	participants.addItem( name );
	show();
    }
}
