/**
  * This class will eventually provide a general interface to the communication
  * library.  THis will include UDP, TCP, IP multicast, and reliable multicast.
  * This class currently only provides the
  * TCP Communication to allow the client side
  * of a socket connection to LabView gen_conn vis. 
  */
// the methods of the class are
//      int writeString( String ) = write a string, returns string length
//      String readString() = read the next string, returns the string read
//      close() = close the connection
//  The constructor opens the connection.
//
/**  NOTE: right now the UDP connection does not use the port specified to
  *       receive messages but it does use that port when sending messages.
  */

package CamClnt;

//Akenti imports 
import iaik.pkcs.*;
import iaik.security.ssl.*;

// regular Java imports
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;
// The rest of the Akenti imports
import LBL.tmp.*;
import java.security.*;
import java.security.cert.*;
// CIF imports
import cif.comm.*;
import cif.toolkit.*;


public class GenComm 
   {
     /** specifies the type of the connection {UDP, TCPServ, TCPClnt, UUMulti, UOMulti, RSrcMulti, ROMulti }
       */
     public String type = "UDP";  // Connection type
     private static final int DEFAULT_PORT = 6777;
     private String remoteAddr;
     // next set of variables for TCP
     private Socket client_sock;   // communication socket
     private DataInputStream sin;  // for socket input
     private DataOutputStream sout;  // for socket output
     // next set of variables for UDP
     private int port;              // port to use for datagram socket
     private InetAddress addr;      // address of remote host
     private DatagramSocket dout;   // datagram socket for in and out
     private MulticastSocket mout;  // IP multicast socket for in and out
     private static final boolean DEBUG = false; // to get debugging printouts

     // next set of variables for Akenti
     // set to true if you want to connect to secure servers
     private static final boolean AKENTI = false; 
     // pointer to hold reference to the Akenti UDPHash object
     private Object hashobj = null; 
     // indicates whether a security context has been established
     private boolean secure = false;  
     private Frame fm;
     public NSKeyReader keyreader = null;
     private String  cafile = null;
     private MakeConnection mc = null;
     private SecurityInterface secint = null;

     // Next set of variables for CIF
     private static final boolean USE_CIF = false;
     private Connection cifconn = null;
     private static final int CIFPORT = 7775;


     public static void usage()
	{
	System.out.println( "Usage: java MyClient <hostname> [<port>]");
	System.exit(0);
	}

     //  Build constructors for all permutations of the hostname and port 
     //  arguments
     /** Constructor that takes as an argument the requested connection type 
       * and opens the appropriate connection
       */

     public GenComm( String requestedType ) throws IOException
	{
	  this( requestedType, "localhost" );
	}

     /** Constructor that takes as an argument the requested connection type and
       * remote hostname or multicast address and opens the appropriate 
       * connection.
       */

     public GenComm( String requestedType, String hostname ) throws IOException
	{
	  this( requestedType, hostname, DEFAULT_PORT);
	}

     /** Constructor that takes as an argument the requested connection type and
       * remote hostname or multicast address and the desired port.  It opens 
       * the appropriate connection.
       */

     public GenComm(String requestedType, String hostname, int port) 
	throws IOException
     {
	  this( requestedType, hostname, port, false, false );
     }

     /** Constructor that takes as an argument the requested connection type and
       * remote hostname or multicast address and the desired port.  It opens 
       * the appropriate connection.
       */
     public GenComm(String requestedType, String hostname, int port, 
	boolean useAkenti, boolean useCIF) 
	throws IOException, UnknownHostException
     {
	type = requestedType;
	this.port = port;
	if (hostname.equals(""))
	{
	    if (DEBUG)
	      System.out.println("No hostname supplied to GenComm constructor:"
		 + hostname );
	    return;
	}
	if( port <= 0 )
	{
	    if( DEBUG )
	      System.out.println("Port specified to GenComm constructor is out of range: " + port);
	    return;
	}
	remoteAddr = hostname;
	try { addr = InetAddress.getByName( hostname ); }
	catch( UnknownHostException e ) 
	{
	    if (DEBUG)
	      System.out.println("No IP address for the specified host: " 
		+ hostname);
	}
	if (USE_CIF) 
	{
	    // initialize the CIF Factory
	    // Call CIF::activate()--need to do this once per application 
	    // but can do it more times if we want.  
	    // CIF communication only works for TCPclnt for now.
	    Comm.activate();
	}
	if (type == "TCPclnt" || type == "TCPsrv") 
        {
	    if (USE_CIF && type == "TCPclnt")
	    {
		String url = "x-cif-tcp://" + remoteAddr + ":" + CIFPORT; 
		try { cifconn = Factory.get_Connection(url); }
		catch(Object_Active_Exception e) { 
		   System.out.println("CIF.send got Object Active Exception");
		   e.printStackTrace(); 
		}
		catch(Comm_Inactive_Exception e) { 
		   System.out.println("CIF.send got Comm Inactive Exception");
		   e.printStackTrace(); 
		}
		catch(Comm_Failure_Exception e) { 
	           System.out.println("CIF.send got Comm Failure Exception");
		   e.printStackTrace(); 
		}
		catch(Bad_Parameter_Exception e) { 
		   System.out.println("CIF.get_connection got Bad Parameter Exception");
		   e.printStackTrace(); 
		}
		catch(InterruptedException e) { 
		   System.out.println("CIF.get_connection got Interrupted Exception");
		   e.printStackTrace(); 
		}
	    }	
	    else
	    {  
	        try { OpenSock( hostname, port ); }
	        catch( IOException e ) { throw e;}
	    }
	}
	else if (type == "UDP") 
        {
	    if( AKENTI ) 
	    {
		// first read the p12 certificate file so that the identity
	        // information is initialized when MakeConnection is called.
		getP12( );
		// pop up the dialog box that shows the current security status
		secint = new SecurityInterface( (new Frame()));
		// now to attempt to get authorization from the devserv for this 
		// identity to control the camera system
		callMakeConnection( );
		if( mc != null ) {
		    mc.addConnectionListener( secint );
		    mc.run();
		}
	    }
	    if (USE_CIF)
	    {
		// We should open a CIF udp connection.  But this is not yet
	        // working.
	    } 
	    else
	        dout = new DatagramSocket( );
	}
	else if( type == "UUM" || type == "UOM" ) {
	    mout = new MulticastSocket( port );
	    mout.joinGroup( addr );
	}
	else 
	    System.err.println("Unknown communication type specified " + type);
     }

     /* Open the client socket and setup the data streams for the socket input 
        and output used if this is a TCP socket.
     */

     private void OpenSock( String hostname, int port ) throws IOException
     {
	/* Put the following code in a try block so we can do the exception
	   handling at the end of the block.
 	*/	
	try
        {
	    // Create a socket to communicate to the host and port requested
	    this.client_sock = new Socket( hostname, port );
	    // Create streams for reading and writing to the socket
	    this.sin = new DataInputStream( client_sock.getInputStream() );
	    this.sout = new DataOutputStream( client_sock.getOutputStream() );
    
	    // Indicate to the user that the connection has been made
	    if (DEBUG)
	      System.out.println( "Connected to " 
		  + client_sock.getInetAddress() + "/" + client_sock.getPort());
        }
	catch( IOException e ) 
        { 
	    System.err.println( e );
	    throw e;
        }
    }

     /** Write an ASCII string to the connection.  
       * The arguments are the remote host to write to and the line to write.
       */
     public int writeString( String line, String hostname ) throws IOException
     {
	try {
	   InetAddress tempaddr = InetAddress.getByName( hostname );
	}
	catch( UnknownHostException e ) {
	    System.out.println( "Unable to get IP address of host: " + hostname
		 + " sending to " + remoteAddr );
	    hostname = remoteAddr;
	}

	if (!hostname.equalsIgnoreCase(remoteAddr))
	{
	    /* We just changed the host we want to connect to for the remote
	       end so take the appropriate action to fix the connection before
	       writing the command to the remote host.
 	    */ 
 	    remoteAddr = hostname;
	    addr = InetAddress.getByName(hostname);
	    if (DEBUG)
		System.out.println("Have a new hostname about to establish connection to " + hostname );

	    /* NOTE: If it is a UDP connection (CIF or non-CIF) we don't need
	       to change anything in the connection except the data fields of
	       the current object which we just did.
	    */		

	    if (USE_CIF && type == "TCPclnt")
	    {
		try
	 	{
		   cifconn.close();
		   String url = "x-cif-tcp://" + hostname + ":" + CIFPORT;
		   cifconn = Factory.get_Connection(url);
		}
	        catch(Object_Active_Exception e)
	        {
		   System.out.println("CIF.get_Connection got Object Active Exception");
		   e.printStackTrace();
		}
	        catch(Object_Inactive_Exception e)
	        {
		   System.out.println("CIF.get_Connection got Object Inactive Exception");
		   e.printStackTrace();
		}
	        catch(Comm_Inactive_Exception e)
	        {
		   System.out.println("CIF.get_Connection got Comm Inactive Exception");
		   e.printStackTrace();
		}
	        catch(Comm_Failure_Exception e)
	        {
		   System.out.println("CIF.get_Connection got Comm Failure Exception");
		   e.printStackTrace();
		}
	        catch(Bad_Parameter_Exception e)
	        {
		   System.out.println("CIF.get_Connection got Bad Parameter Exception");
		   e.printStackTrace();
		}
	        catch(InterruptedException e)
	        {
		   System.out.println("CIF.get_Connection got Bad Parameter Exception");
		   e.printStackTrace();
		}
	    } 
	    else
            {		
	       try
	       {
	          if (type == "TCPclnt" || type == "TCPsrv")
	          {
		     close();
		     OpenSock( hostname, port );
	          }
	          else if (type == "UUM" || type == "UOM")
	          {
		     mout.leaveGroup(addr);
		     mout.joinGroup(InetAddress.getByName(hostname));
	          }
	          if (DEBUG)
		     System.out.println("Changing connection to " + hostname);
	          if (AKENTI && type == "UDP")
	             callMakeConnection();
	        }
	        catch(IOException e)
	        {
	          System.err.println( e );
	          throw e;
	        }
	    }
	}
	int temp;
	try { temp = this.writeString(line); }
	catch(IOException e)
	{
	    System.err.println( e );
	    throw e;
	}
	return temp;
     }


     /** Write an ASCII string to the connection.  
       * The argument is the line to write.
       */
     public int writeString( String line ) throws IOException
     {
        if (AKENTI && type == "UDP" && hashobj != null) 
	{
	   if (((UDPHash)hashobj).isValid()) 
 	   {
	      try {
		String templine = ((UDPHash)hashobj).prepCommand( line );
		line = templine;
		if (DEBUG)
		    System.out.println( "Hashed command is: " + line );
	        }
	        catch(UninitializedSecretException e) {
		    System.out.println("Caught uninitialized secret exception");
		}
	   }
	   else
		System.out.println("Attempt to write to devserv before security context established");
        }

	/* Determine the length of the string and try to send that as an integer
	   on the socket and then send the string.
	*/
	int len = line.length();
    
	if (DEBUG)
	  System.out.println("Len: " + len + " Line: " + line );
	if (type == "UDP" || type == "UUM" || type == "UOM") 
        {
	   // Need to create a byte array that is packed with the string
	   String junk = String.valueOf( len );
	   int len2 = junk.length();
	   int totallen = len + len2 + 1;
	   byte[] msgbytes = new byte[ totallen ];
	   String junk2 = new String(" ");
	
	   System.arraycopy( junk.getBytes(), 0, msgbytes, 0, len2 );
	   System.arraycopy( junk2.getBytes(), 0, msgbytes, len2, 1 );
	   System.arraycopy( line.getBytes(), 0, msgbytes, len2+1, len );
	
	   if (DEBUG)
	      System.out.println("input length " + totallen + " : " + line);

	   DatagramPacket msg = new DatagramPacket(msgbytes,totallen,addr,port);

	   // Send the string.  If we're using CIF, get a connection first. 
	   if (USE_CIF && type == "UDP")
           {
	    	String url = "x-cif-tcp://" + remoteAddr + ":" + CIFPORT;
	        try { cifconn = Factory.get_Connection(url); }
	        catch(Object_Active_Exception e) {
		   System.out.println("CIF.get_Connection got Object Active Exception");
		   e.printStackTrace();
		}  
	        catch(Comm_Inactive_Exception e) {
		   System.out.println("CIF.get_Connection got Comm Inactive Exception");
		   e.printStackTrace();
	        }  
	        catch(Comm_Failure_Exception e) {
		   System.out.println("CIF.get_Connection got Comm Failure Exception");
		   e.printStackTrace();
	        }  
	        catch(Bad_Parameter_Exception e) {
		   System.out.println("CIF.get_Connection got Bad Parameter Exception");
		   e.printStackTrace();
		}  
	        catch(InterruptedException e) {
		   System.out.println("CIF.get_Connection got Interrupted Exception");
		   e.printStackTrace();
		}  

		try { cifconn.send(msgbytes, totallen); }
		catch(Object_Inactive_Exception e) {
		   System.out.println("CIF.send got Object Inactive Exception");
		   e.printStackTrace();
		}
		catch(Comm_Inactive_Exception e) {
		   System.out.println("CIF.send got Comm Inactive Exception");
		   e.printStackTrace();
		}
		catch(Comm_Flow_Exception e) {
		   System.out.println("CIF.send got Comm Flow Exception");
		   e.printStackTrace();
		}
		catch(Comm_Failure_Exception e) {
		   System.out.println("CIF.send got Comm Failure Exception");
		   e.printStackTrace();
		}
           }
	   else if (type == "UDP")
	   {
	      try { dout.send(msg); }
              catch(IOException e) {
		System.err.println(e);
		throw e;
	      } 	
	   } 
	   else
	   {
	      try { mout.send(msg); }
              catch(IOException e) {
		System.err.println(e);
		throw e;
	      } 	
           }
       }
       if (type == "TCPclnt" || type == "TCPsrv") 
       {
	    if (USE_CIF) 
	    {
		try { cifconn.send(line.getBytes(), line.length()); }
		catch(Object_Inactive_Exception e) {
		   System.out.println("CIF.send got Object Inactive Exception");
		   e.printStackTrace();
		}
		catch(Comm_Inactive_Exception e) {
		   System.out.println("CIF.send got Comm Inactive Exception");
		   e.printStackTrace();
		}
		catch(Comm_Flow_Exception e) {
		   System.out.println("CIF.send got Comm Flow Exception");
		   e.printStackTrace();
		}
		catch(Comm_Failure_Exception e) {
		   System.out.println("CIF.send got Comm Failure Exception");
		   e.printStackTrace();
		}
	    }
	    else
	    {
		sout.writeInt(len);
                // Send the string to the server
		try { 
		   sout.writeBytes(line); 
	           sout.flush();
		}
		catch(IOException e) {
		   System.err.println(e);
		   throw e;
		}
	    }
	}
        return len;
     }

     /** read an ASCII string from the connection.  The argument is the 
       * timeout to use in deciding how long to wait for the string.  Right now
       * the UDP and UUM messages are assumed to be 1024 bytes or smaller.
       * A non-zero timeout as the argument will cause the read to be non-blocking
       * and only wait the specified number of seconds.  A timeout of zero will
       * cause the call to be blocking.
       */
     public String readString(int timeout)
     {
	int len;
	String rtnline = null;
    
	try
        {
	    // Read a string from the server
	    if( type == "TCPclnt" || type == "TCPsrv" )
	    {
	        if (USE_CIF)
		{
		   try {
		      if (cifconn != null) {
			Message ttlmsg = cifconn.receive();
		      }
		   }
		   catch(Object_Inactive_Exception e) {
			System.out.println("CIF.receive	got Object Active Exception");
			e.printStackTrace();
	           }
		   catch(Comm_Flow_Exception e) {
			System.out.println("CIF.receive	got Comm Flow Exception");
			e.printStackTrace();
	           }
		   catch(Comm_Inactive_Exception e) {
			System.out.println("CIF.receive	got Comm Inactive Exception");
			e.printStackTrace();
	           }
		   catch(Comm_Failure_Exception e) {
			System.out.println("CIF.receive	got Comm Failure Exception");
			e.printStackTrace();
	           }
		   catch(Comm_Would_Block_Exception e) {
			System.out.println("CIF.receive	got Comm Would Block Exception");
			e.printStackTrace();
	           }
		   catch(InterruptedException e) {
			System.out.println("CIF.receive	got InterruptedException");
			e.printStackTrace();
	           }
		}
		else
		{
	           // first to read the length of the string
	           len = sin.readInt();
		   byte temp[] = new byte[len];
		   sin.readFully( temp, 0, len );
		   rtnline = new String( temp );
		}
	    }
	    else if (type == "UDP" || type == "UUM")
	    {
		DatagramPacket msg = new DatagramPacket( new byte[1024], 1024 );
	        if( type == "UDP" ) 
	        {
		  dout.setSoTimeout(timeout);
		  dout.receive(msg);
	        }
		else 
	        {
		  mout.setSoTimeout(timeout);
		  mout.receive(msg);
	        }
		rtnline = new String(msg.getData());
		if (DEBUG)
		  System.out.println("Received: " + msg.getLength() + " : " +  rtnline);
	    }
	    else
	        System.err.println("Attempt to read from socket of unknown type");
        }
	catch(IOException e) 
	{ 
	    //String err = e.getMessage();
	    //if (!err.equals("Receive timed out"))
	    if (!e.getMessage().equals("Receive timed out"))
		System.err.println(e); 
	} 
	return rtnline;
     }


     /** close the connection
       */
     public void close()
     {
	if( DEBUG )
	  System.out.println( "Socket close called" );
	if (USE_CIF)
        {
	     try { cifconn.close(); }
	     catch(Object_Inactive_Exception e) { 
	         System.out.println("CIF.close got Object Inactive Exception"); 
	         e.printStackTrace();
	     }
	     catch(Comm_Inactive_Exception e) { 
	         System.out.println("CIF.close got Comm Inactive Exception"); 
	         e.printStackTrace();
	     }
	     catch(Comm_Failure_Exception e) { 
	         System.out.println("CIF.close got Comm Failure Exception"); 
	         e.printStackTrace();
	     }
	 }
	 else
	 {
	     if (type == "TCPclnt" || type == "TCPsrv")
	     {
		if (client_sock != null)
	        {
		    try { client_sock.close(); }
		    catch(IOException e) {
			System.out.println("client_sock.close() got IOException");
		        e.printStackTrace();
		    }
		    client_sock = null;	
	        }
	     }
	     else if (type == "UDP")
	     {
		if (dout != null)
		{
		   dout.close();
		   dout = null;
		}
	     }
	     else if (type == "UUM" || type == "UOM")
	     {
	        if (mout != null)
		{
		   mout.close();
		   mout = null;
		}
	     } 
	 }
     }

     protected void finalize()      
     {
	if (USE_CIF)
	    Comm.deactivate();
	else
	{
	    try 
	    { 
	    	if (client_sock != null) client_sock.close(); 
	    	if (dout != null) dout.close();
	    	if (mout != null) mout.close();
	    }
	    catch( IOException e2 ) { ; }
	}
     }

     // The following routines allow the address for the connection
     // to be queried and changed.
     /** Get the current address used for this connection
       */
     public String getAddress()
     {
	return remoteAddr;
     }

     /** Get the Inet representation of the current address of this connaction
       */
     public InetAddress getInetAddress()
     {
	return addr;
     }

     /** Change the address for the connection to the one specified
       */
     public void setAddress( String hostname ) throws IOException
     {
	remoteAddr = hostname;
	addr = InetAddress.getByName( hostname );
	if (type == "TCP" && DEBUG)
	  System.out.println("Need to close current socket and open new one (not implemented yet)");
     }

     /** Connect to the server and negotiate a hash value for the connection
       */
     protected void getP12()
     {
	    if (AKENTI) {
	  fm = new Frame();
	  // open a dialog box to get P12 file name
	  FileDialog fd = new FileDialog(fm,"Specify location of p12 certificate file");
	  fd.show();
	  String p12file = fd.getFile();
	  if( cafile == null ) {
	      if( DEBUG )
		  System.out.println( "p12 file name is " + p12file );
	      FileDialog fca = new FileDialog(fm,"Specify location of CA pem file");
	      fca.show();
	      cafile = fca.getFile();
	  }
	  if( DEBUG )
	      System.out.println( "CA file name is " + cafile );
	  Dialog dpwd = new Dialog( fm, "Enter password to decrypt p12 file", true);
	  TextArea lbl = new TextArea( "Enter Password to decrypt p12 file",1,40,TextArea.SCROLLBARS_NONE );
	  lbl.setEditable( false );
	  dpwd.add( "North", lbl );
	  Button dismiss = new Button( "Accept" );
	  CloseDialog cd = new CloseDialog( dpwd );
	  dismiss.addActionListener( cd );
	  dpwd.add( "South", dismiss );
	  TextField pwd = new TextField( 30 );
	  pwd.setEchoChar( '*' );
	  dpwd.add( "Center", pwd );
	  dpwd.setLocation( 60, 100 );
	  dpwd.pack();
	  dpwd.show();
	  readp12Key( p12file, pwd.getText() );
	  if( DEBUG )
	      System.out.println( "returned from reading the p12 file " );
	    }
      }

      private void readp12Key( String p12file, String passwd ) {
	  if( AKENTI ) {
	  try {
	      if( keyreader == null ) {
		  keyreader = new NSKeyReader();
		  //keyreader.readP12File( p12file, passwd );
		  keyreader.readP12File( p12file, passwd );
	      }
	  }
	  catch( ClassNotFoundException e ) {
	      System.out.println( "Class not found");
	      e.printStackTrace();
	      keyreader = null;
	  }
	  catch( FileNotFoundException e ) {
	      System.out.println( "File not found");
	      e.printStackTrace();
	      keyreader = null;
	  }
	  catch( IOException e ) {
	      System.out.println( "IO exception");
	      e.printStackTrace();
	      keyreader = null;
	  }
	  catch( IllegalAccessException e ) {
	      System.out.println( "illegal access exception");
	      e.printStackTrace();
	      keyreader = null;
	  }
	  catch( InstantiationException e ) {
	      System.out.println( "Instantiation exception");
	      e.printStackTrace();
	      keyreader = null;
	  }
	  catch( PKCSParsingException e ) {
	      System.out.println( "PKCS Parsing exception");
	      e.printStackTrace();
	      keyreader = null;
	  }
	  catch( PKCSException e ) {
	      System.out.println( "PKCS  exception, bad password???");
	      e.printStackTrace();
	      keyreader = null;
	  }
	  catch( NoSuchAlgorithmException e ) {
	      System.out.println( "NoSuchAlgorithm exception");
	      e.printStackTrace();
	      keyreader = null;
	  }
	 }
      }
	  
      private void callMakeConnection() 
      {
          if(AKENTI) 
	  {
	  secure = false;
	  if( cafile == null || keyreader == null ) {
	      System.out.println( "call to make connection without having initialized");
	      secint.failure();
	      return;
	  }
	  try {
	      if( hashobj == null )
		hashobj = new UDPHash();
	      if( DEBUG ) {
		  System.out.println( "About to call Make conn args= " + remoteAddr + " port "+ (port-1) );
		  System.out.println("make connection starting");
	      }
              mc = new MakeConnection( remoteAddr, port-1,
				       keyreader.getX509Certificate(),
				       keyreader.getPrivateKey(),
				       cafile,
				       (UDPHash)hashobj );
	  }
	  catch( CertificateException e ) {
	      System.out.println( "Certificate exception");
	      e.printStackTrace();
	      mc = null;
	      cafile = null;
	  }
	  catch( PKCSException e ) {
	      System.out.println( "PKCS  exception, bad password???");
	      e.printStackTrace();
	      mc = null;
	      cafile = null;
	  }
	  catch( NoSuchAlgorithmException e ) {
	      System.out.println( "NoSuchAlgorithm exception");
	      e.printStackTrace();
	      mc = null;
	      cafile = null;
	  }
	  catch( FileNotFoundException e ) {
	      System.out.println( "File not found");
	      e.printStackTrace();
	      mc = null;
	      cafile = null;
	  }

	  catch( UninitializedP12FileException e ) {
	      System.out.println( "UninitializedP12File exception");
	      e.printStackTrace();
	      mc = null;
	      cafile = null;
	  }
	  catch( ClassNotFoundException e ) {
	      System.out.println( "Class not found");
	      e.printStackTrace();
	      mc = null;
	      cafile = null;
	  }
	  catch( IOException e ) {
	      System.out.println( "IO exception");
	      e.printStackTrace();
	      cafile = null;
	      mc = null;
	  }
	  catch( IllegalAccessException e ) {
	      System.out.println( "illegal access exception");
	      e.printStackTrace();
	      cafile = null;
	      mc = null;
	  }
	  catch( InstantiationException e ) {
	      System.out.println( "Instantiation exception");
	      e.printStackTrace();
	      mc = null;
	      cafile = null;
	  }
	   }
	  }

     protected class CloseDialog implements ActionListener {
	 Dialog tempdiag;
	 
	 CloseDialog( Dialog dpwd ) {
	     tempdiag = dpwd;
	 }

	 public void actionPerformed( ActionEvent e ) {
	     tempdiag.setVisible( false );
	 }
     }
     
       public class SecurityInterface extends Dialog 
	 implements ConnectionListener,ActionListener {
	   private Button indicator;
	   private TextField username;

	   SecurityInterface(Frame fsec) {
	       super( fsec, "Security Information" );
	       indicator = new Button( "Waiting" );
	       indicator.setBackground( Color.yellow );
	       indicator.setForeground( Color.black );
	       add( "West", indicator );
	       if( keyreader != null )
		   username = new TextField( keyreader.getCN());
	       else {
		   username = new TextField( "unknown" );
		   indicator.setBackground( Color.red );
		   indicator.setLabel( "Failure" );
	       }
	       username.setEditable( false );
	       add( "Center", username );
	       Button change = new Button( "Change Users" );
	       change.addActionListener( this );
	       add( "South", change );
	       pack();
	       show();
	   }
	   public void success( ConnectionEvent e ) {
	       secure = true;
	       mc.removeConnectionListener( this );
	       mc = null;
	       if( DEBUG )
		   System.out.println( "Security interface got connection success too" );
	       indicator.setBackground( Color.green );
	       indicator.setLabel( "Secure" );
	   }
	   public void failure( ConnectionEvent e ) {
	       this.failure();
	   }
	   public void failure( ) {
	       if( DEBUG )
		   System.out.println( "Security Interface got connection failure");
	       indicator.setBackground( Color.red );
	       indicator.setLabel( "Failed" );
	       username.setText( "unknown" );
	       if( mc != null )
		   mc.removeConnectionListener( this );
	       mc = null;
	   }
	   public void actionPerformed( ActionEvent e ) {
	       if( DEBUG )
		   System.out.println( "Got a request to change users" );
	       if( AKENTI ) {
		   // now to change users which means we need to get new p12 info
		   keyreader = null;
		   indicator.setBackground( Color.yellow );
		   indicator.setLabel( "Waiting" );
		   username.setText( "unknown" );
		   getP12();
		   if( keyreader != null )
		       username.setText( keyreader.getCN());
		   callMakeConnection();
		   if( mc != null ) {
		       mc.addConnectionListener( this );
		       mc.run();
		   }
	       }
	   }
	       
       }
}
