/*
 * @(#)SenderReportWindow.java	1.11 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package GUI;
import javax.media.Player;
import javax.media.rtp.session.*;
import com.sun.media.rtp.util.Signed;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;



public class SenderReportWindow extends Frame implements ActionListener
 {
     RTCPSenderReport mysr;
     Button rb;
     Button sf;
     RTCPFeedbackWindow child = null;
     RTCPFeedbackWindow childsf = null;
     // textfields that need to be updated for a SR are the fields in the SR
     TextField tfntpmsw;
     TextField tfntplsw;
     TextField tfrtp;
     TextField tfpktcnt;
     TextField tfbytecnt;
     SDESWindow sdes;
     Vector reportblks = null;
     RTCPFeedback feedback = null;
     
    public SenderReportWindow(RTCPSenderReport sr){
	super("RTCP Sender Report");
	this.mysr = sr;
	setFont(new Font("Helvetica", Font.PLAIN, 14));
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.gridwidth = GridBagConstraints.REMAINDER;
	setLayout(gridbag);
	
	sdes = new SDESWindow(sr.getSourceDescription());
	gridbag.setConstraints(sdes,c);
	add(sdes);
	// after adding SDES packet, now add the SR packet
	Label p1 = new Label("SSRC of RTCPReport Sender");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p1,c);
	add(p1);
	
	long ssrc = sr.getSSRC();
	if (ssrc < 0)
	    ssrc = Signed.UnsignedInt((int)ssrc);
	String ssrcstr = (new Long(ssrc)).toString();
	TextField t1 = new TextField(ssrcstr);
	t1.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(t1,c);
	add(t1,c);
	
	Label p2 = new Label("NTPTimeStampLSW in secs.");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p2,c);
	add(p2);
	
	
	tfntplsw = new TextField();
	tfntplsw.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(tfntplsw,c);
	add(tfntplsw,c);
	    
	Label p3 = new Label("NTPTimeStampMSW in secs");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p3,c);
	add(p3);
	
	tfntpmsw = new TextField();
	tfntpmsw.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(tfntpmsw,c);
	add(tfntpmsw,c);

	Label px = new Label("RTPTimeStamp in RTPtime");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(px,c);
	add(px);
	
	tfrtp = new TextField();
	tfrtp.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(tfrtp,c);
	add(tfrtp,c);
	    
	Label p4 = new Label("Sender Byte Count, no. bytes");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p4,c);
	add(p4);
	
	tfbytecnt = new TextField();
	tfbytecnt.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(tfbytecnt,c);
	add(tfbytecnt,c);

	Label p5 = new Label("Sender Packet Count, no. packets");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p5,c);
	add(p5);
	
	tfpktcnt = new TextField();
	tfpktcnt.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(tfpktcnt,c);
	add(tfpktcnt,c);
	
	printSenderInfo(sr);

	rb = new Button("View Report Blocks in this SR");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(rb,c);
	rb.addActionListener(this);
	reportblks = sr.getFeedbackReports();
	if  (reportblks.size() == 0)
	    rb.setEnabled(false);
	add(rb);
	sf = new Button("View Report Blocks sent by me for this SSRC");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(sf,c);
	sf.addActionListener(this);
	feedback = sr.getSenderFeedback();
	if (feedback == null)
	    sf.setEnabled(false);
	add(sf);	
	pack();
	show();
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                if (child != null)
		    child.close();
		if (childsf != null)
		    childsf.close();
		dispose();
            }
        });
	
    }
    public void update(RTCPReport sr){
	printSenderInfo(sr);
	sdes.update(sr.getSourceDescription());
    }
    public void printSenderInfo(RTCPReport sr){
	if (((RTCPSenderReport)sr).getNTPTimeStampMSW() < 0)
	    tfntpmsw.setText( toUnsignedStr(((RTCPSenderReport)sr).getNTPTimeStampMSW()));
	else
	     tfntpmsw.setText (( new Long(((RTCPSenderReport)sr).getNTPTimeStampMSW())).toString());


	if (((RTCPSenderReport)sr).getNTPTimeStampLSW() < 0)
	    tfntplsw.setText( toUnsignedStr(((RTCPSenderReport)sr).getNTPTimeStampLSW()));
	else
	     tfntplsw.setText (( new Long(((RTCPSenderReport)sr).getNTPTimeStampLSW())).toString());

	if (((RTCPSenderReport)sr).getRTPTimeStamp() < 0)
	    tfrtp.setText( toUnsignedStr(((RTCPSenderReport)sr).getRTPTimeStamp()));
	else
	     tfrtp.setText (( new Long(((RTCPSenderReport)sr).getRTPTimeStamp())).toString());

	if (((RTCPSenderReport)sr).getSenderPacketCount() < 0)
	    tfpktcnt.setText( toUnsignedStr(((RTCPSenderReport)sr).getSenderPacketCount()));
	else
	     tfpktcnt.setText (( new Long(((RTCPSenderReport)sr).getSenderPacketCount())).toString());

	if (((RTCPSenderReport)sr).getSenderByteCount() < 0)
	    tfbytecnt.setText( toUnsignedStr(((RTCPSenderReport)sr).getSenderByteCount()));
	else
	     tfbytecnt.setText (( new Long(((RTCPSenderReport)sr).getSenderByteCount())).toString());
    }
			       
    private String toUnsignedStr(long  value){
	long lval = Signed.UnsignedInt((int)value);
	return (new Long(lval)).toString();
    }
    public void actionPerformed(ActionEvent evt){
	Button source = (Button)evt.getSource();
	if (source == rb)
	   child =  new RTCPFeedbackWindow(reportblks);
	if (source == sf){
	    Vector reportlist = new Vector(1);
	    reportlist.addElement((Object)feedback);
	    childsf = new RTCPFeedbackWindow(reportlist);
	}
    }
     
    public void close(){
	if (child != null)
	    child.close();
	if (childsf != null)
	    childsf.close();
	dispose();
    }
}
	

    
