/*
 * @(#)SDESWindow.java	1.12 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package GUI;
import javax.media.Player;
import javax.media.rtp.session.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;



public class SDESWindow extends Panel{
    private TextField cnametf;
    private TextField nametf;
    private TextField emailtf;
    private TextField phonetf;
    private TextField loctf;
    private TextField tooltf;
    private TextField notetf;
    private TextField privtf;
    
    public SDESWindow(Vector sdeslist){
	super();
	setFont(new Font("Helvetica", Font.PLAIN, 14));
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.weightx = 1.0;
	c.weighty = 1.0;
	setLayout(gridbag);
	

	Label p2 = new Label("Source Description Objects");
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(p2,c);
	add(p2);
	
	Label cname = new Label ("CNAME");
	c.gridwidth =  GridBagConstraints.RELATIVE;
	gridbag.setConstraints(cname,c);
	add(cname);


	cnametf = new TextField();
	cnametf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(cnametf,c);
	add(cnametf);

	Label name = new Label ("NAME");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(name,c);
	add(name);

	nametf = new TextField();
	nametf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(nametf,c);
	add(nametf);
	
	Label email = new Label ("EMAIL");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(email,c);
	add(email);

	emailtf = new TextField();
	emailtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(emailtf,c);
	add(emailtf);

	Label phone = new Label ("PHONE");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(phone,c);
	add(phone);

	phonetf = new TextField();
	phonetf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(phonetf,c);
	add(phonetf);

	Label loc  = new Label ("LOC");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(loc,c);
	add(loc);

	loctf = new TextField();
	loctf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(loctf,c);
	add(loctf);
	
	Label tool  = new Label ("TOOL");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(tool,c);
	add(tool);

	tooltf = new TextField();
	tooltf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(tooltf,c);
	add(tooltf);
	
	Label note = new Label ("NOTE");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(note,c);
	add(note);

	notetf = new TextField();
	notetf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(notetf,c);
	add(notetf);

	Label priv = new Label ("PRIVATE");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(priv,c);
	add(priv);

	privtf = new TextField();
	privtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(privtf,c);
	add(privtf);
	FillInSDES(sdeslist);
	//pack();
	setVisible(true);
    }
    public void update(Vector sdeslist){
	FillInSDES(sdeslist);
    }
    public void FillInSDES(Vector sdeslist){
	// fill in the cname
	if (sdeslist == null)
	    return;
	for (int i = 0; i < sdeslist.size();i++){
	    RTCPSourceDescription des = (RTCPSourceDescription)sdeslist.elementAt(i);
	    switch (des.getType()){
	    case RTCPSourceDescription.SOURCE_DESC_CNAME:
		String cname = des.getDescription();
		cnametf.setText(des.getDescription());
		break;
	    case RTCPSourceDescription.SOURCE_DESC_NAME:
		nametf.setText(des.getDescription());
		break;
	    case RTCPSourceDescription.SOURCE_DESC_EMAIL:
		emailtf.setText(des.getDescription());
		break;
	    case RTCPSourceDescription.SOURCE_DESC_PHONE:
		phonetf.setText(des.getDescription());
		break;
	    case RTCPSourceDescription.SOURCE_DESC_LOC:
		loctf.setText(des.getDescription());
		break;
	    case RTCPSourceDescription.SOURCE_DESC_TOOL:
		tooltf.setText(des.getDescription());
		break;
	    case RTCPSourceDescription.SOURCE_DESC_NOTE:
		notetf.setText(des.getDescription());
		break;
	    case RTCPSourceDescription.SOURCE_DESC_PRIV:
		privtf.setText(des.getDescription());
		break;
	    default:
		break;
	    }
	}// end of for loop
    }
}
	

