/*
 * @(#)ReceiverReportWindow.java	1.11 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package GUI;
import javax.media.Player;
import javax.media.rtp.session.*;
import com.sun.media.rtp.util.Signed;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;



public class ReceiverReportWindow extends Frame implements ActionListener
 {
     RTCPReceiverReport myrr;
     Button rb;
     RTCPFeedbackWindow child = null;
     Vector reportblks = null;
    
     
    public ReceiverReportWindow(RTCPReceiverReport rr){
	super("RTCP Receiver Report");
	this.myrr = rr;
	setFont(new Font("Helvetica", Font.PLAIN, 14));
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.weightx = 1.0;
	c.weighty = 1.0;
	setLayout(gridbag);
	
	SDESWindow sdes = new SDESWindow(rr.getSourceDescription());
	gridbag.setConstraints(sdes,c);
	add(sdes);
	// after adding SDES packet, now add the SR packet
	Label p1 = new Label("SSRC of RTCPReport Sender");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p1,c);
	add(p1);
	
	long ssrc = rr.getSSRC();
	if (ssrc < 0)
	    ssrc = Signed.UnsignedInt((int)ssrc);
	String ssrcstr = (new Long(ssrc)).toString();
	TextField t1 = new TextField(ssrcstr);
	t1.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(t1,c);
	add(t1,c);
	rb = new Button("View Report Blocks in this RR");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(rb,c);
	rb.addActionListener(this);
	reportblks = rr.getFeedbackReports();
	if ((reportblks == null) || (reportblks.size() == 0))
	    rb.setEnabled(false);
	add(rb);
	pack();
	show();
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
		if (child != null)
		    child.close();
                dispose();
            }
        });

    }
    public void close(){
	if (child != null)
	    child.close();
	dispose();
    }
    public void update(RTCPReport rr){
	if (child != null)
	    child.update(rr);
    }
    public void actionPerformed(ActionEvent evt){
	Button source = (Button)evt.getSource();
	if (source == rb){
	   child =  new RTCPFeedbackWindow(reportblks);
	}
    }
}

