/*
 * @(#)RTPStreamWindow.java	1.21 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package GUI;
import javax.media.*;
import javax.media.rtp.session.*;
import com.sun.media.rtp.util.Signed;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import com.sun.media.ui.*;

public class RTPStreamWindow extends Frame implements
RTPRemoteListener, ActionListener {

    RTPSessionManager mgr;
    RTPStream mystream;
    RTCPSenderReport myreport;
    Label state;
    List l;
    SenderReportWindow childsr = null;
    RTPStatsWindow statsw = null;
    String typestr = null;
    Button statsb = null;
    Player myplayer = null;
    boolean readytocreate = false;

    public RTPStreamWindow(RTPSessionManager mgr,
			   RTPStream stream){
	super("RTPStream");
	//setSize(700,400);
	this.mgr = mgr;
	this.mystream = stream;
	
	setFont(new Font("Helvetica", Font.PLAIN, 14));
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.weightx = 1.0;
	c.weighty = 1.0;
	setLayout(gridbag);
	RTPParticipant owner = mystream.getParticipant();
	myreport = mystream.getSenderReport();
	Label l1 = new Label("Owner Participant");
	gridbag.setConstraints(l1,c);
	add(l1);
	c.gridwidth = GridBagConstraints.REMAINDER;
	TextField t1 = new TextField(owner.getCNAME());
	t1.setEditable(false);
	gridbag.setConstraints(t1,c);
	add(t1);
	Label l3 = new Label ("SSRC");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(l3,c);
	add(l3);
	long ssrc = mystream.getSSRC();
	if (ssrc < 0)
	    ssrc = Signed.UnsignedInt((int)ssrc);
	String ssrcstr = (new Long(ssrc)).toString();
	TextField t2 = new TextField(ssrcstr);
	t2.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(t2,c);
	add(t2);	
	Label l2 = new Label ("Latest Sender Report");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(l2,c);
	add(l2);
	l = new List(1);
	l.setBackground(Color.white);
	l.addItem("EMPTY");
	l.setEnabled(false);
	l.addActionListener(this);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(l,c);
	add(l);
	statsb = new Button("Source Reception Statistics");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(statsb,c);
	add(statsb);
	statsb.addActionListener(this);
	pack();
	show();
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
		if (childsr != null)
		    childsr.close();
		if (statsw != null)
		    statsw.close();
                dispose();
            }
        });
	mgr.addRemoteListener(this);
    }
	

    public void actionPerformed(ActionEvent event){
	Player newplayer = null;
	PlayerWindow playerWindow = null;
	
	if (event.getSource() instanceof List)
	    childsr = new SenderReportWindow(myreport);
	// here add controls for RTPRecvStream.removePlayer() which is
	// mystream.removePlayer
	// add controls for creating a new player using
	// RTPSessionManager.createRecvStreamPlayer() passing this
	// RTPRecvStream. Note that at any point, only the player is
	// invalid, the RTPRecvStream will not be invalid
	if (event.getSource() instanceof Button){
	    Button source = (Button)event.getSource();
	    if (source == statsb)
		statsw = new RTPStatsWindow((RTPRecvStream)mystream);
	    
	}// if instance of Button
    }// action performed
    
    public void close(){
	if (childsr != null)
	    childsr.close();
	if (statsw != null)
	    statsw.close();
	dispose();
    }
   
    // Since this class implements the RTPSessionListener interface,
    // it must implement the methods of that interface. For now, we
    // just have dummies here
    public void update(RTPRemoteEvent event){
	if (event instanceof RecvSenderReportEvent){
	    RTCPSenderReport report = ((RecvSenderReportEvent)event).getReport();
	    RTPStream stream = report.getStream();
	    if (stream == null)
		return;
	    if (stream == mystream){
		l.replaceItem("View Latest SR",0);
		l.setEnabled( true);
		if (childsr != null)
		    childsr.update(myreport);
	    }
	}
    }
    
}// end of class

    
