/*
 * @(#)RTPStatsWindow.java	1.15 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package GUI;

import java.awt.*;
import java.util.*;
import java.awt.event.*;

import javax.media.rtp.session.*;

public class RTPStatsWindow extends Frame implements Runnable{

    RTPRecvStream stream;
    Thread thread;
    TextField pdulost;
    TextField pduproc;
    TextField pdumisord;
    TextField pduinvalid;
    TextField pdudup;
    GridBagLayout gridbag;
    GridBagConstraints c;
        
    public RTPStatsWindow(RTPRecvStream stream ){
	super("Source RTP Statistics");
	setSize(220,500);
	gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.NORTHWEST;
        c.weightx = 1.0;
        c.weighty = 1.0;
        setLayout(gridbag);
	show();
	this.stream = stream;
	Label lpdu = new Label ("Lost PDU");
	c.gridwidth = GridBagConstraints.RELATIVE;
        gridbag.setConstraints(lpdu,c);
        add(lpdu);
	pdulost = new TextField(10);
	pdulost.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(pdulost,c);
	add(pdulost);
	Label ppdu = new Label ("Processed PDU");
	c.gridwidth = GridBagConstraints.RELATIVE;
        gridbag.setConstraints(ppdu,c);
        add(ppdu);
	pduproc = new TextField(10);
	pduproc.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(pduproc,c);
	add(pduproc);
	Label mispdu = new Label("Misordered PDU");
	c.gridwidth = GridBagConstraints.RELATIVE;
        gridbag.setConstraints(mispdu,c);
        add(mispdu);
	pdumisord = new TextField(10);
	pdumisord.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(pdumisord,c);
	add(pdumisord);
	Label invalid = new Label ("Invalid PDU");
	c.gridwidth = GridBagConstraints.RELATIVE;
        gridbag.setConstraints(invalid,c);
        add(invalid);
	pduinvalid = new TextField(10);
	pduinvalid.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(pduinvalid,c);
	add(pduinvalid);
	Label dup = new Label ("Duplicate PDU");
	c.gridwidth = GridBagConstraints.RELATIVE;
        gridbag.setConstraints(dup,c);
        add(dup);
	pdudup = new TextField(10);
	pdudup.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
        gridbag.setConstraints(pdudup,c);
	add(pdudup);
	show();
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
		close();
            }
        });
	thread = new Thread(this, "RTPStream Stats Thread");
	thread.setDaemon(true);
	thread.start();
	
    }

    public void close(){
	thread.stop();
	dispose();
    }
    public void run(){
	while(true){
	    RTPReceptionStats stats = stream.getSourceReceptionStats();
	    pdulost.setText( (new Integer(stats.getPDUlost())).toString());
	    pduproc.setText((new Integer(stats.getPDUProcessed())).toString());
	    pdumisord.setText((new Integer(stats.getPDUMisOrd())).toString());
	    pduinvalid.setText((new Integer(stats.getPDUInvalid())).toString());
	    pdudup.setText((new Integer(stats.getPDUDuplicate())).toString());
	    if (isShowing())
		show();
	    try{
		Thread.sleep(1000);
	    }catch (InterruptedException e){}
	}
    }
}
