/*
 * @(#)RTPParticipantWindow.java	1.22 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package GUI;
import javax.media.Player;
import javax.media.rtp.session.*;
import com.sun.media.rtp.util.Signed;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

public class RTPParticipantWindow extends Frame implements
RTPRecvStreamListener, RTPRemoteListener, ActionListener {

    RTPSessionManager mgr;
    Vector recvstreamlist;
    RTPParticipant mypartc;
    List recvlistgui;
    List reportlistgui;
    Vector reportlist;
    private static final int ADD = 1;
    private static final int DELETE = 2;
    Vector children = null;
    Vector repchildren = null;
    SDESWindow sdes = null;
    
    
    public RTPParticipantWindow(RTPSessionManager mgr,
				RTPParticipant partc){
	super("RTPParticipant");
	this.mgr = mgr;
	this.mypartc = partc;
	
	setFont(new Font("Helvetica", Font.PLAIN, 14));
	GridBagLayout gridbag = new GridBagLayout();
	GridBagConstraints c = new GridBagConstraints();
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.weightx = 1.0;
	c.weighty = 1.0;
	setLayout(gridbag);

	Label p = new Label("CName");
	gridbag.setConstraints(p,c);
	add(p);

	TextField t = new TextField(mypartc.getCNAME());
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(t,c);
	t.setEditable(false);
	add(t);

	Label p1 = new Label("Streams");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p1,c);
	add(p1,c);

	
	recvlistgui = new List(5);
	recvlistgui.setBackground(Color.white);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(recvlistgui,c);
	add(recvlistgui);
	// add a list of recvstreams
	recvstreamlist  = mypartc.getStreams();
	// if this participant is a passive local or remote
	// participant, the streams will  return null
	if (recvstreamlist.size() == 0){
	    recvlistgui.addItem("PASSIVE PARTICIPANT: NO STREAMS");
	    recvlistgui.setEnabled(false);
	}
	if (recvstreamlist.size() > 0){
	    // this indicates the participant is active, now it could
	    // be local or remote, depending on the instance of the
	    // objects in the returned vector
	    for (int i = 0; i < recvstreamlist.size();i++){
		String type = null;
		RTPStream stream = (RTPStream)recvstreamlist.elementAt(i);
		if (stream instanceof RTPRecvStream)
		    type = "REMOTE: RECV STREAM ";
		RTPParticipant owner =
		    ((RTPStream)recvstreamlist.elementAt(i)).getParticipant();
		recvlistgui.addItem(type + ": " + owner.getCNAME());
	    }
	    recvlistgui.addActionListener(this);
	}
	sdes = new
	    SDESWindow(mypartc.getSourceDescription());
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(sdes,c);
	add(sdes,c);
	// each element in the vector is an RTCPReport object
	reportlist = mypartc.getReports();
	Label p2 = new Label("Latest RTCPReport sent by SSRCs of RTPParticipant");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(p2,c);
	add(p2,c);
	reportlistgui = new List(3);
	reportlistgui.setBackground(Color.white);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(reportlistgui,c);
	add(reportlistgui);
	reportlistgui.addActionListener(this);
	for (int i = 0; i < reportlist.size();i++){
	    RTCPReport report = (RTCPReport)reportlist.elementAt(i);
	    long ssrc = report.getSSRC();
	    if (ssrc < 0)
		ssrc = Signed.UnsignedInt((int)ssrc);
	    reportlistgui.addItem((new Long(ssrc)).toString());
	}
	setSize(550,600);
	//pack();
	show();
	children = new Vector();
	repchildren = new Vector();
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
		for (int i= 0; i < children.size(); i++)
		   ((RTPStreamWindow)children.elementAt(i)).close();
		for (int j=0; j < repchildren.size();j++){
		    Object window = (Object)repchildren.elementAt(j);
		    if (window instanceof SenderReportWindow)
			((SenderReportWindow)window).close();
		    if (window instanceof ReceiverReportWindow)
			((ReceiverReportWindow)window).close();
		}
		dispose();
            }
        });
	
	mgr.addRecvStreamListener(this);
	mgr.addRemoteListener(this);
    }
    public void close(){
	for (int i =0; i < children.size(); i++)	    
	    ((RTPStreamWindow)children.elementAt(i)).close();
	for (int j=0; j < repchildren.size();j++){
		    Object window = (Object)repchildren.elementAt(j);
		    if (window instanceof SenderReportWindow)
			((SenderReportWindow)window).close();
		    if (window instanceof ReceiverReportWindow)
			((ReceiverReportWindow)window).close();
	}
	dispose();
    }
    public void actionPerformed(ActionEvent event){
	List sourcelist = (List)event.getSource();
	int index = sourcelist.getSelectedIndex();
	if (sourcelist == recvlistgui){
	    RTPStream chosen = (RTPStream)recvstreamlist.elementAt(index);
	    RTPStreamWindow child = new RTPStreamWindow(mgr,chosen);
	    children.addElement((Object)child);
	}
	if (sourcelist == reportlistgui){
	    RTCPReport chosenreport =
		(RTCPReport)reportlist.elementAt(index);
	    // Ep how does one distinguish between instanceof each at bottom?
	    if (chosenreport instanceof RTCPReceiverReport){
		ReceiverReportWindow child = new
		    ReceiverReportWindow((RTCPReceiverReport)chosenreport);
		repchildren.addElement((Object)child);
	    }
	    if (chosenreport instanceof RTCPSenderReport){
	    SenderReportWindow child = new
		SenderReportWindow((RTCPSenderReport)chosenreport);
	    repchildren.addElement((Object)child);
	    }
	
	}
    }
	
    // Since this class implements the RTPSessionListener interface,
    // it must implement the methods of that interface. For now, we
    // just have dummies here
    
    public void update(RTPRecvStreamEvent event){
	RTPParticipant sender = null;
	RTPRecvStream stream =  null;
	//
	if (event instanceof NewRecvStreamEvent){
	    stream = ((NewRecvStreamEvent)event).getRecvStream();
	    if (stream == null)
		return;
	    sender = stream.getParticipant();
	    if (sender != mypartc)
		return;
	    updaterecvlist(ADD, stream);
	}
	if (event instanceof TimeOutEvent){
	    stream =  ((TimeOutEvent)event).getRecvStream();
	    if (stream == null)
		return;
	    sender = stream.getParticipant();
	    if (sender != mypartc)
		return;
	    updaterecvlist(DELETE,stream);
	}
	if (event instanceof ByeEvent){
	    stream = ((ByeEvent)event).getRecvStream();
	    if (stream == null)
		return;
	    sender = stream.getParticipant();
	    if (sender != mypartc)
		return;
	    updaterecvlist(DELETE,stream);
	}
    }

    public void update(RTPRemoteEvent event){
	RTPParticipant sender = null;
	RTPRecvStream stream =  null;
	// if a RR was received, make sure it was from this participant
	if ((event instanceof RecvReceiverReportEvent) &&
	    (mypartc.getStreams().size() == 0)){
	    // the participant is a Passive participnat, update the
	    // report and SDES for this participant in the GUI
	    RTCPReceiverReport report = ((RecvReceiverReportEvent)event).getReport();
	    if (report == null)
		return;
	    sender = report.getParticipant();
	    if (sender == null)
		return;
	    if (sender != mypartc)
		return;
	    if (sdes != null)
		sdes.update(report.getSourceDescription());
	    reportlist = sender.getReports();
	    int i =0;
	    for (i =0; i < reportlist.size();i++){
		RTCPReport currreport = (RTCPReport)reportlist.elementAt(i);
		long ssrc = currreport.getSSRC();
		if (ssrc < 0)
		    ssrc = Signed.UnsignedInt((int)ssrc);
		// first get the item associated with the specified index.
		if (reportlistgui != null){
		    String item = reportlistgui.getItem(i);
		    if (item != null)
			reportlistgui.replaceItem((new Long(ssrc)).toString(),i);
		    else
			reportlistgui.addItem((new Long(ssrc)).toString());
		}
	    }
	    //for (int j = i+1; j < 3; j++)
	    //reportlistgui.delItem(j);
	}

	// if an SR was received, make sure it was from this participant
	if ((event instanceof RecvSenderReportEvent) &&
	    (mypartc.getStreams().size() > 0)){
	    // the participant is an active participant, update the
	    // sender report and SDES items
	    RTCPSenderReport reports =
		((RecvSenderReportEvent)event).getReport();
	    if (reports == null)
		return;
	    sender = reports.getParticipant();
	    if (sender != mypartc)
		return;
	    if (sdes != null)
		sdes.update(reports.getSourceDescription());
	    reportlist = sender.getReports();
	    int i =0;
	    for ( i =0; i < reportlist.size();i++){
		RTCPReport currreports = (RTCPReport)reportlist.elementAt(i);
		long ssrc = currreports.getSSRC();
		if (ssrc < 0)
		    ssrc = Signed.UnsignedInt((int)ssrc);
		if (reportlistgui != null){
		    String item = reportlistgui.getItem(i);
		    if (item != null)
			reportlistgui.replaceItem((new Long(ssrc)).toString(),i);
		    else
			reportlistgui.addItem((new Long(ssrc)).toString());
		}
	    }
	    //int rows = reportlistgui.getRows();
	    //for (int j = i+1; j < rows; j++)
	    //reportlistgui.delItem(j);
	}
    }	
    public void updaterecvlist(int mode,RTPRecvStream newstream){	// 
	// typically will be called with ADD only if the participant
	// is active and has a new RTPSendStream(local) or RTPRecvStream(remote)
	if (newstream == null)
	    return;
	int count = 0;
	String cname = null;
	switch (mode){
	case ADD:
	    cname = newstream.getParticipant().getCNAME();
	    count = recvlistgui.getItemCount();
	    for (int i =0; i < count; i++){
		if ((recvlistgui.getItem(i).equals(cname)))
		    return;
	    }
	    //	    System.out.println("Adding recvstream for " +
	    //	       newstream.getParticipant().getCNAME());
	    recvstreamlist.addElement((Object)newstream);
	    if (newstream instanceof RTPRecvStream)
		recvlistgui.addItem("REMOTE: RECV STREAM " +
				    newstream.getParticipant().getCNAME());
	    break;
	case DELETE:
	    cname = newstream.getParticipant().getCNAME();
	    //System.out.println("updaterecvlist:delete");
	    count = recvlistgui.getItemCount();
	    for (int i=0; i < count; i++){
		if ((recvlistgui.getItem(i)).equals(cname)){
		    recvlistgui.delItem(i);		     
		    recvstreamlist.removeElement((Object)newstream);
		    break;
		}
	    }
	    break;	    
	
	}// end of switch
    }// end of updaterecvlist
}

