/*
 * @(#)RTCPFeedbackWindow.java	1.11 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package GUI;
import javax.media.Player;
import com.sun.media.rtp.util.Signed;
import javax.media.rtp.session.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;



public class RTCPFeedbackWindow extends Frame implements ActionListener
 {
     Vector reportblks;
     int currindex = 0;
     int size = 0;
     Button next;
     Button prev;
     private TextField dlsrtf;
     private TextField flosttf;
     private TextField jittertf;
     private TextField lsrtf;
     private TextField numlosttf;
     private TextField ssrctf;
     private TextField seqnumtf;
     private GridBagLayout gridbag;
     private GridBagConstraints c;
     
    public RTCPFeedbackWindow(Vector reportblks){
	super("RTCP Report Block/RTCPFeedback");
	this.reportblks = reportblks;
	setFont(new Font("Helvetica", Font.PLAIN, 14));
	gridbag = new GridBagLayout();
	c = new GridBagConstraints();
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.weightx = 1.0;
	c.weighty = 1.0;
	setLayout(gridbag);
	// outline will fill in all the labels and textfields
	// these will be filled in with the current index of feedback reports
	Outline();
	// two buttons to go back and forth between the RTCPReport
	// blocks
	next = new Button("Next RTCPFeedback");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(next,c);
	next.addActionListener(this);
	add(next);
	prev = new Button("Prev RTCPFeedback");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(prev,c);
	prev.addActionListener(this);
	prev.setEnabled(false);
	add(prev);	
	if (reportblks != null ){
	    size = reportblks.size();
	    if (size > 0){
		Fill((RTCPFeedback)(reportblks.elementAt(currindex)));
	    }
	    if (size == 1){
		next.setEnabled(false);
	    }
	}
	pack();
	show();
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
                dispose();
            }
        });
	
    }
    public void close(){
	dispose();
    }
    public void actionPerformed(ActionEvent event){
	Button chosen = (Button)event.getSource();
	int tempcurrindex;
	if (chosen == next){
	    tempcurrindex = currindex +1;
	    if (tempcurrindex +1 <= reportblks.size()){
		Fill((RTCPFeedback)(reportblks.elementAt(++currindex)));
		if (tempcurrindex +1 == reportblks.size()){
		    next.setEnabled(false);
		    prev.setEnabled(true);
		}else{
		    next.setEnabled(true);
		    prev.setEnabled(true);
		}
		
	    }
	}
	if (chosen == prev){
	    tempcurrindex = currindex -1;
	    if (tempcurrindex >= 0)
		Fill((RTCPFeedback)(reportblks.elementAt(--currindex)));
	    if (tempcurrindex == 0){
		prev.setEnabled(false);
		next.setEnabled(true);
	    }else{
		prev.setEnabled(true);
		next.setEnabled(true);
	    }
	}    
    }

     
    private void Outline(){
	Label dlsr = new Label ("DLSR in secs");
	gridbag.setConstraints(dlsr,c);
	add(dlsr);

	dlsrtf = new TextField();
	dlsrtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(dlsrtf,c);
	add(dlsrtf);

	Label flost = new Label ("FractionLost");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(flost,c);
	add(flost);

	flosttf = new TextField();
	flosttf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(flosttf,c);
	add(flosttf);

	Label numlost = new Label ("Number Lost in pkts");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(numlost,c);
	add(numlost);

	numlosttf = new TextField();
	numlosttf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(numlosttf,c);
	add(numlosttf);
	
	Label jitter = new Label ("Jitter in RTPtime");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(jitter,c);
	add(jitter);

	jittertf = new TextField();
	jittertf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(jittertf,c);
	add(jittertf);

	Label lsr = new Label ("LSR in NTPtime");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(lsr,c);
	add(lsr);

	lsrtf = new TextField();
	lsrtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(lsrtf,c);
	add(lsrtf);

	Label ssrc  = new Label ("SSRC");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(ssrc,c);
	add(ssrc);

	ssrctf = new TextField();
	ssrctf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(ssrctf,c);
	add(ssrctf);
	
	Label seqnum  = new Label ("XtndSeqNum");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(seqnum,c);
	add(seqnum);

	seqnumtf = new TextField();
	seqnumtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(seqnumtf,c);
	add(seqnumtf);
    }
    public void update(RTCPReport report){
	reportblks = report.getFeedbackReports();
	size = reportblks.size();
	if (size > 0)	
	    Fill((RTCPFeedback)(reportblks.elementAt(currindex)));
	if (size == 1){
	    next.setEnabled(false);
	    prev.setEnabled(false);
	}
	else
	    next.setEnabled(true);
    }
    private void Fill(RTCPFeedback reportblk){
	if (reportblk == null){
	    //System.out.println("Fill: recd null reportblk");
	    return;
	}
	long ssrc = reportblk.getSSRC();
	if (ssrc < 0)
	    ssrc = Signed.UnsignedInt((int)ssrc);
	//System.out.println("current fill ssrc is " + ssrc);
	ssrctf.setText( (new Long(ssrc)).toString());
	double flost = (reportblk.getFractionLost())/256.0;
	
	flosttf.setText( (new Double(flost)).toString());
	long numlost = reportblk.getNumLost();
	numlosttf.setText ( (new Long(numlost)).toString());
	long seqnum = reportblk.getXtndSeqNum();
	seqnumtf.setText((new Long(seqnum)).toString());
	long jitter = reportblk.getJitter();
	jittertf.setText((new Long(jitter)).toString());
	long lsr = reportblk.getLSR();
	lsrtf.setText((new Long(lsr)).toString());
	double dlsr = (double)(reportblk.getDLSR()/65536.0);
	dlsrtf.setText((new Double(dlsr)).toString());

	
    }
    
     
}
		    
	    
       
	    
	    
	
