/*
 * @(#)ParticipantListWindow.java	1.29 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package GUI;
import javax.media.Player;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import javax.media.rtp.session.*;

public class ParticipantListWindow extends Frame implements
RTPSessionListener, RTPRecvStreamListener, ActionListener{
    // each element of the vector is a
    // RTPParticipant Object
    Vector remotelist = null;
    Vector locallist = null;
    Vector passivelist = null;
    Vector activelist = null;
    List remotelistgui = null;
    List locallistgui = null;
    List passivelistgui = null;
    List activelistgui = null;
    Button statsbutton;
    private static final int ADD = 1;
    private static final int DELETE =2;
    private static final int GRAY = 3;
    private static final int UNGRAY = 4;
    RTPSessionManager mgr = null;
    Vector children = null;
    GridBagLayout gridbag;
    GridBagConstraints c;
    OverallStatsWindow stats = null;
    
    // constructor
    public ParticipantListWindow(RTPSessionManager  mgr){
	super("Participant List");
	setFont(new Font("Helvetica", Font.BOLD, 12));
	gridbag = new GridBagLayout();
	c = new GridBagConstraints();
	c.fill = GridBagConstraints.HORIZONTAL;
	c.anchor = GridBagConstraints.NORTHWEST;
	c.weightx = 1.0;
	c.weighty = 1.0;
	setLayout(gridbag);
	this.mgr = mgr;
	children = new Vector();
	remotelistgui = CreateList("Remote",5);
	locallistgui = CreateList("Local",5);
	passivelistgui = CreateList("Passive",5);
	activelistgui = CreateList("Active",5);
	remotelist = this.mgr.getRemoteParticipants();
	RTPLocalParticipant lpart = this.mgr.getLocalParticipant();
	locallist = new Vector(1);
	locallist.addElement(lpart);
	passivelist = this.mgr.getPassiveParticipants();
	activelist = this.mgr.getActiveParticipants();
	AddToList(remotelistgui, remotelist);
	AddToList(locallistgui, locallist);
	AddToList(passivelistgui, passivelist);
	AddToList(activelistgui, activelist);
	setSize(500,400);
	statsbutton = new Button ("Statistics");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(statsbutton,c);
	add(statsbutton);
	statsbutton.addActionListener(this);
	//pack();
	if (isShowing())
	    show();
	
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
		for (int i=0; i< children.size(); i++){
		    ((RTPParticipantWindow)children.elementAt(i)).close();
		}
		if (stats != null)
		    stats.close();
		dispose();
            }
        });
	mgr.addSessionListener(this);
	mgr.addRecvStreamListener(this);
	
    }
    public void Show(){
	show();
    }
    private List CreateList(String type,int numentry){
	Label label = new Label(type);
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(label,c);
	add(label);
	List list = new List(numentry);
	list.setBackground(Color.white);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(list,c);
	add(list);
	list.addActionListener(this);
	return list;
    }
    private void AddToList(List list, Vector vlist){
	if ((list == null) || (vlist == null))
	    return;
	for (int i =0; i < vlist.size(); i++){
	    RTPParticipant part= (RTPParticipant)vlist.elementAt(i);
	    list.addItem(part.getCNAME());
	}
    }

    public void close(){
	for (int i = 0; i < children.size(); i++){
	    ((RTPParticipantWindow)children.elementAt(i)).close();
	}
	if (stats != null)
	    stats.close();
	dispose();
    }
    public void actionPerformed(ActionEvent event){
	Object source  = event.getSource();
	if (source instanceof List){
	    List guilist = (List)event.getSource();
	    int i = guilist.getSelectedIndex();
	    Vector list = VectorofGUI(guilist);
	    try{
		RTPParticipant chosenpart = (RTPParticipant)list.elementAt(i);
		RTPParticipantWindow child = new RTPParticipantWindow(mgr,chosenpart);
		
		children.addElement((Object)child);
	    }catch (NullPointerException e){
		System.err.println("Null PointerException ");
		e.printStackTrace();
		return;
	    }
	}
	if (source instanceof Button){
	    stats = new OverallStatsWindow(mgr);
	}
    }
    private Vector VectorofGUI(List gui){
	if (gui == remotelistgui)
	    return remotelist;
	if (gui == locallistgui)
	    return locallist;
	if (gui == passivelistgui)
	    return passivelist;
	if (gui == activelistgui)
	    return activelist;
	return null;
    }
    
    public void update (RTPSessionEvent event){
	RTPParticipant part = null;
	RTPRecvStream stream = null;
	// if this is a new participant event, add this participant to
	// the list of already existant participants.
	if (event instanceof NewParticipantEvent){
	    part = ((NewParticipantEvent)event).getParticipant();
	    if (part == null)
		return;
	    if (part instanceof RTPLocalParticipant)
		updateplist(locallistgui,ADD,part);
	    if (part instanceof RTPRemoteParticipant)
		updateplist(remotelistgui,ADD,part);
	    if ((part.getStreams()).size() == 0)
		updateplist(passivelistgui,ADD,part);
	    if ((part.getStreams()).size() > 0)
		updateplist(activelistgui,ADD,part);
	    return;
	}
    }
    
    
    public void update(RTPRecvStreamEvent event){
	RTPParticipant part = null;
	RTPRecvStream stream = null;
	// if this is a timeOut or ByeEvent, we need to remove the
	// participants from the list of participants
	if ((event instanceof TimeOutEvent) || (event instanceof
						 ByeEvent)){
	    
	    if ((event instanceof TimeOutEvent) && (((TimeOutEvent)event).participantLeaving())){
		part = ((TimeOutEvent)event).getParticipant();
	    }
	    if ((event instanceof ByeEvent) &&
		(((ByeEvent)event).participantLeaving())){
		part = ((ByeEvent)event).getParticipant();
		
	    }
	    if (part == null)
		return;
	    if (part instanceof RTPLocalParticipant)
		updateplist(locallistgui,DELETE,part);
	    if (part instanceof RTPRemoteParticipant)
		updateplist(remotelistgui,DELETE,part);
	    updateplist(passivelistgui,DELETE,part);
	    updateplist(activelistgui,DELETE,part);
	}// end of event instancoef timeOutEvent or ByeEvent
	// if this is a newRecvStreamEvent, from an already existant
	// PASSVE paritcipant, we will need to remove the
	// RTPParticipant from the Passive list and add it to the
	// active list
	if (event instanceof NewRecvStreamEvent){
	    stream = ((NewRecvStreamEvent)event).getRecvStream();
	    part = stream.getParticipant();
	    if(part == null)
		return;
	    updateplist(activelistgui, ADD, part);
	    updateplist(passivelistgui,DELETE,part);
	    updateplist(activelistgui,ADD,part);
	}

	if (event instanceof InactiveRecvStreamEvent){
	    // we need to gray this one out, but for now we will replace it by
	    // saying it is inactive
	    part = ((InactiveRecvStreamEvent)event).getParticipant();
	    if (part == null)
		return;
	    // if this participant was sending data, it must be a
	    // remote and active participant
	    updateplist(passivelistgui,GRAY,part);
	    updateplist(activelistgui,GRAY,part);
	    updateplist(remotelistgui,GRAY,part);
	}
	if (event instanceof ActiveRecvStreamEvent){
	    part = ((ActiveRecvStreamEvent)event).getParticipant();
	    if (part == null){
		return;
	    }
	    updateplist(passivelistgui,UNGRAY,part);
	    updateplist(activelistgui, UNGRAY, part);
	    updateplist(remotelistgui,UNGRAY, part);
	}
    }
	    
    private  void updateplist(List plistgui,int mode, RTPParticipant part){	
	Vector plist = null;
	if ((plistgui == null) || (part == null))
	    return;
	switch (mode){
	case ADD:
	    // before adding the item to the gui, make sure it is not
	    // already present or a previous INACTIVE entry did not
	    // exist for this participant 
	    for (int i = 0 ; i < plistgui.getItemCount() ; i++){
		if ( (plistgui.getItem(i)).equals(part.getCNAME()) )
		    return;
		String entry = plistgui.getItem(i);
		try{
		    String cname = entry.substring(0,(entry.lastIndexOf("INACTIVE")));
		    if (cname.equals(part.getCNAME()))
			plistgui.delItem(i);		
		}catch (Exception e){
		}
	    }
	    plistgui.addItem(part.getCNAME());
	    plist = VectorofGUI(plistgui);
	    if (plist != null)
		plist.addElement((Object)part);
	    if (isShowing())
		show();
	    break;
	case DELETE:
	    //    System.out.println("updatelist: delete");
	    plist = VectorofGUI(plistgui);
	    
	    for (int i = 0; i < plistgui.getItemCount(); i++){
		if ((plistgui.getItem(i)).equals(part.getCNAME())){
		    plistgui.delItem(i);
		    if (plist != null)
			plist.removeElement((Object)part);
		    break;
		}
		// also check to see if this CNAME is present with INACTIVE string
		try{
		    String entry = plistgui.getItem(i);
		    String cname = entry.substring(0,(entry.lastIndexOf("INACTIVE")));
		    if (cname.equals(part.getCNAME()))
			plistgui.delItem(i);
		    if (plist != null)
			plist.removeElement((Object)part);
		    break;
		}catch (Exception e){}
		    
	    }
	    if (isShowing())
		show();
	    break;
	case GRAY:
	    plist = VectorofGUI(plistgui);
	    for (int i =0; i < plistgui.getItemCount() ; i++){
		if ((plistgui.getItem(i)).equals(part.getCNAME())){
		    String s = plistgui.getItem(i) + "INACTIVE";
		    plistgui.replaceItem(s,i);
		}
	    }
	    break;

	case UNGRAY:
	    plist = VectorofGUI(plistgui);
	    boolean found = false;
	    for (int i =0; i < plist.size() ; i++){
		RTPParticipant partc = (RTPParticipant)plist.elementAt(i);
		if (((partc.getCNAME()).equals(part.getCNAME()))){
		    // participant which has become active is partof
		    // the participant list
		    found = true;
		    break;
		}
	    }
	    // the participant is part of this list and has
	    // been grayed out, we need to find the correct
	    // entry in the GUI and replace it
	    if (found){    
		String s = part.getCNAME() + "INACTIVE";
		for (int j=0; j < plistgui.getItemCount(); j++){
		    if ((plistgui.getItem(j)).equals(s)){
			plistgui.replaceItem(part.getCNAME(),j);
			break;
		    }
		}
	    }// if found
	    break;
	    
	}// end of switch
    }// end of updategui
}



	    
	
	
