/*
 * @(#)OverallStatsWindow.java	1.14 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package GUI;

import java.awt.*;
import java.util.*;
import java.awt.event.*;

import javax.media.rtp.session.*;

public class OverallStatsWindow extends Frame implements Runnable{

    RTPSessionManager mymgr;
    Thread thread;
    TextField pktsrecdtf;
    TextField bytesrecdtf;
    TextField badrtppktstf;
    TextField localcolltf;
    TextField remotecolltf;
    TextField pktsloopedtf;
    TextField transfailedtf;
    TextField rtcprectfd;
    TextField srrecdtf;
    TextField badrtcppktstf;
    TextField unknowntf;
    TextField malrrtf;
    TextField malsdestf;
    TextField malbyetf;
    TextField malsrtf;
    GridBagLayout gridbag;
    GridBagConstraints c;
    
    public OverallStatsWindow(RTPSessionManager mgr){
	super("Overall RTP Statistics");
	setSize(250,500);
	gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.NORTHWEST;
        c.weightx = 1.0;
        c.weighty = 1.0;
        setLayout(gridbag);
	show();
	mymgr = mgr;
	Label pktsrecdl = new Label ("Total Packets Recd");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(pktsrecdl,c);
	add(pktsrecdl);
	pktsrecdtf = new TextField(10);
	pktsrecdtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(pktsrecdtf,c);
	add(pktsrecdtf);
	Label bytesrcdl = new Label("Total Bytes Recd");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(bytesrcdl,c);
	add(bytesrcdl);
	bytesrecdtf = new TextField(10);
	bytesrecdtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(bytesrecdtf,c);
	add(bytesrecdtf);
	Label badrtpl = new Label("Bad RTP Packets");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(badrtpl,c);
	add(badrtpl);
	badrtppktstf = new TextField(10);
	badrtppktstf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(badrtppktstf,c);
	add(badrtppktstf);
	Label localcoll = new  Label ("Local Collisions");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(localcoll,c);
	add(localcoll);
	localcolltf = new TextField(10);
	localcolltf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(localcolltf,c);
	add(localcolltf);
	Label remotecoll = new Label ("Remote Collisions");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(remotecoll,c);
	add(remotecoll);
	remotecolltf = new TextField(10);
	remotecolltf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(remotecolltf,c);
	add(remotecolltf);
	Label pktslpd = new Label ("Packets Looped");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(pktslpd,c);
	add(pktslpd);
	pktsloopedtf = new TextField(10);
	pktsloopedtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(pktsloopedtf,c);
	add(pktsloopedtf);
	Label ftrans = new Label ("Failed Transmissions");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(ftrans,c);
	add(ftrans);
	transfailedtf = new TextField(10);
	transfailedtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(transfailedtf,c);
	add( transfailedtf);
	Label rtcprecd = new Label ("RTCP Packets Recd");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(rtcprecd,c);
	add(rtcprecd);
	rtcprectfd = new TextField(10);
	rtcprectfd.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(rtcprectfd,c);
	add( rtcprectfd);
	Label srrecd = new Label ("SR Packets Recd");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(srrecd,c);
	add(srrecd);
	srrecdtf = new TextField(10);
	srrecdtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(srrecdtf,c);
	add( srrecdtf);
	Label badrtcp = new  Label ("Bad RTCP Packets Recd");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(badrtcp,c);
	add(badrtcp);
	badrtcppktstf = new TextField(10);
	badrtcppktstf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(badrtcppktstf,c);
	add( badrtcppktstf);
	Label urtcp = new Label ("Unknown RTCP Types");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(urtcp,c);
	add(urtcp);
	unknowntf = new TextField(10);
	unknowntf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(unknowntf,c);
	add( unknowntf);
	Label malrr = new Label ("Malformed RR");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(malrr,c);
	add(malrr);
	malrrtf = new TextField(10);
	malrrtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(malrrtf,c);
	add( malrrtf);
	Label malsdes = new Label ("Malformed SDES");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(malsdes,c);
	add(malsdes);
	malsdestf = new TextField(10);
	malsdestf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(malsdestf,c);
	add( malsdestf);
	Label malbye = new Label ("Malformed BYE");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(malbye,c);
	add(malbye);
	malbyetf = new TextField(10);
	malbyetf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(malbyetf,c);
	add(malbyetf);
	Label malsr = new Label ("Malformed SR");
	c.gridwidth = GridBagConstraints.RELATIVE;
	gridbag.setConstraints(malsr,c);
	add(malsr);
	malsrtf = new TextField(10);
	malsrtf.setEditable(false);
	c.gridwidth = GridBagConstraints.REMAINDER;
	gridbag.setConstraints(malsrtf,c);
	add( malsrtf);
	show();
	this.addWindowListener( new WindowAdapter(){
            public void windowClosing(WindowEvent e){
		close();
            }
        });
	thread = new Thread(this, "OverallStatsThread");
	thread.setDaemon(true);
	thread.start();
	
    }

    public void close(){
	thread.stop();
	dispose();
    }
    public void run(){
	while(true){
	    GlobalReceptionStats stats = mymgr.getGlobalReceptionStats();
	    pktsrecdtf.setText( (new Integer(stats.getPacketsRecd())).toString());
	    bytesrecdtf.setText((new Integer(stats.getBytesRecd())).toString());
	    badrtppktstf.setText((new Integer(stats.getBadRTPkts())).toString());
	    localcolltf.setText((new Integer(stats.getLocalColls())).toString());
	    remotecolltf.setText((new Integer(stats.getRemoteColls())).toString());
	    pktsloopedtf.setText((new Integer(stats.getPacketsLooped())).toString());
	    transfailedtf.setText((new Integer(stats.getTransmitFailed())).toString());
	    rtcprectfd.setText((new Integer(stats.getRTCPRecd())).toString());
	    srrecdtf.setText((new Integer(stats.getSRRecd())).toString());
	    badrtcppktstf.setText((new Integer(stats.getBadRTCPPkts())).toString());
	    unknowntf.setText((new Integer(stats.getUnknownTypes())).toString());
	    malrrtf.setText((new Integer(stats.getMalformedRR())).toString());
	    malsdestf.setText((new Integer(stats.getMalformedSDES())).toString());
	    malbyetf.setText((new Integer(stats.getMalformedBye())).toString());
	    malsrtf.setText((new Integer(stats.getMalformedSR())).toString());
	    if (isShowing())
		show();
	    try{
		Thread.sleep(1000);
	    }catch (InterruptedException e){}
	}
    }
}
