/*
 * @(#)EncodingUtil.java	1.18 98/03/28
 *
 * Copyright 1996-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package CamClnt;

import javax.media.protocol.DataSource;
import javax.media.rtp.RTPControl;
import javax.media.rtp.BaseEncodingInfo;
import javax.media.rtp.session.RTPSessionManager;

/**
 * This is a utility class which configures a RTP datasource with
 * dynamic payload information using the interface defined in
 * javax.media.rtp.RTPControl.The main method is the Init() method which
 * will take in a datasource as an argument. Currently, the datasource
 * is configured for dynamic payload types used by ShowmeTvT, which
 * tranmits DVI compressed audio at 44.1 KHz at
 * dynamic RTP payloads 18. The JMF RTP handlers
 * are capable of handling these content types. The RTP datasource must
 * be configured with dynamic payload information prior to attempting to
 * playback these streams.
 */
public class EncodingUtil {
    private static final String rtpcontrol = "javax.media.rtp.RTPControl";

    
    public static void Init(DataSource ds){
	RTPControl control = (RTPControl)ds.getControl(rtpcontrol);
	if (control == null){
	    //System.out.println("The datasource " + ds +
	    //	       "\n does not support the RTPCOntrol interface..." +
	    //	       "\nexiting from EncodingUtil.Init()");
	    return;
	}
	Init(control);
    }
    public static void Init(RTPSessionManager mgr){
	BaseEncodingInfo info = null;
       	// dvi at 44100 Hz
	info = new BaseEncodingInfo(18,"dvi",44100,
				    1,4,
				    null);
	mgr.addEncoding(info);
    }
    
    public static  void Init(RTPControl control){
	BaseEncodingInfo info = null;
	if (control == null)
	    return;
	// since we have a handle over the RTPControl interface, now
	// add our  dynamic payload types for DVI. These are
	// PT         encoding      audio/video    clock rate    channels
	//             name          (A/V)          (Hz)          (audio)
	// 18          DVI4          A              44100          1
	// for each of the payloads, we will create a
	// BaseEncodingInfo (defined in
	// javax.media.rtp.BaseEncodingInfo) and add this to the
	// RTPControl interface. Note: as explained in the RTPControl
	// inteface, addEncoding() can be called repeatedly in order
	// to enter dynamic payload encoding information.
	info = new BaseEncodingInfo(18,"dvi",44100,
				    1,4,
				    null);
	control.addEncoding(info);
    }
}
