//  This class will handle processing the device server status
//  messages and updating the interface appropriately.
//
package CamClnt;

import java.io.*;
import java.util.*;

class CamClntMsgFormatException extends Exception {
    public CamClntMsgFormatException(){
	super();
    }
    public CamClntMsgFormatException( String s ) {
	super(s);
    }
}

public class DevservStatus extends GenComm implements Runnable {

  // define the variables
    camInterface  camint = null;
    String        devservHost;
    String        statusAddr;
    int           statusPort;
    private static final boolean DEBUG = false; // for debugging printouts
    DevservInfo   devInfo;
    Hashtable     devservHash = new Hashtable();
    boolean       newdevserv = false;
    boolean       connected = false;

  // define the constructor.  The call to super will open the connection
  DevservStatus(camInterface caller, String address, int port, String type) 
	throws IOException 
      {
	super(type, address, port);
	statusAddr = address;
	statusPort = port;
	camint = caller;
        connected = true;
	if (DEBUG)
	  System.out.println("Connected for addr " + address + " port " + port 
		+ " type " + type); 
      }

  public void run() {
      while (true)
        readDevString(0,true);
  }

  /** Send a description request to any server via multicast.
    */

  public int writeDevString(String cmd)
  {
	String command = getHeader() + cmd;
	try {
	    if (connected)
	        writeString(command, statusAddr);
	}
	catch(IOException e)
	{
	    connected = false;
	    return 0;
        }
	return 1; 
  }

  private String getHeader()
  {
	long temp = System.currentTimeMillis();
	return (temp + " " + statusAddr + "#");
  }	

  /** Read the status or description message sent by the server This
    * message will come from the machine that is
    * actually running the cameras.
    */
  public int readDevString(int timeout, boolean reconfig) {
      String msg = readString(timeout);
      if (msg == null) { return 0; }	
      if (DEBUG)
	System.out.println("Message received: " + msg);
      StringTokenizer stmsg = new StringTokenizer( msg, "#\u0000\u00A0\uFEFF\u0009\u000B\u000C", false );
      if( stmsg.countTokens() < 5 ) {
	  System.out.println( "Something wrong received a devserv description of less than 5 lines");
	  return 0;
      }
      try {
	  processLine1( stmsg.nextToken());
	  processLine2( stmsg.nextToken());
	  processLine3( stmsg.nextToken());
	  processLine4( stmsg.nextToken());
	  processLine5( stmsg.nextToken());
      }
      catch (CamClntMsgFormatException e ){
	  System.out.println("Bad devserv multicast description message format: " 
	       + e.getMessage());
	  return(0);
      }
      int lineNo = 6;

      devInfo.setDeviceNumber( stmsg.countTokens());
      if( DEBUG )
	  System.out.println("Number of devices is " + devInfo.numDevices);
      int currentDev = 0;
      while (stmsg.hasMoreTokens()) 
      {
	String currentLine = stmsg.nextToken();
	currentDev++;
	lineNo++;
	if( DEBUG )
	  System.out.println( "msgline " + lineNo + ": " + currentLine);
	
	// the first string for each line will contain the device type, index and
	// description.
	StringTokenizer stline = new StringTokenizer(currentLine,"@\u00A0\uFEFF\u0009\u000B\u000C", false);
	if (stline == null)
	    break;
	int dofNo = 0;
	devInfo.devices[currentDev - 1].setNumbDOFs( stline.countTokens());
	while (stline.hasMoreTokens()) 
        {
	    String currentDof = stline.nextToken();
	    dofNo++;
	    StringTokenizer stdof = new StringTokenizer( currentDof );
	    if( dofNo == 1 ) {
		try {
		    devInfo.devices[currentDev-1].setType( stdof.nextToken());
		    devInfo.devices[currentDev-1].setUnitNumber(Integer.parseInt( stdof.nextToken()));
		    stdof.nextToken("\"");
		    devInfo.devices[currentDev-1].setUnitDescription( stdof.nextToken());
		    stdof.nextToken(" \u00A0\uFEFF\u0009\u000B\u000C");
		}
		catch ( NoSuchElementException e ) {
		    System.out.println("Incorrect message format for line 1 of a device " 
			+ "in the devserv description message");
		    return 0;
		}
		if( DEBUG )
		    devInfo.devices[currentDev-1].print();
	    }
	    try {
		devInfo.devices[currentDev-1].DOFs[dofNo-1].setName( stdof.nextToken());
		if( devInfo.devices[currentDev-1].DOFs[dofNo-1].getName().equals( "pnp" ))
		    devInfo.devices[currentDev-1].DOFs[dofNo-1].setFeature( stdof.nextToken());
	    }
	    catch ( NoSuchElementException e ) {
		System.out.println("Incorrect message format for dof name of a device " 
			+ "in the devserv description message");
		return 0;
	    }
	    int valNo = 0;
	    while( stdof.hasMoreTokens()){
		String val = stdof.nextToken();
		if( val.equals( "on" ))
		    devInfo.devices[currentDev-1].DOFs[dofNo-1].setValue(valNo,
					 (double)1.0);
		else if( val.equals( "off" ))
		    devInfo.devices[currentDev-1].DOFs[dofNo-1].setValue(valNo, 
					 (double)0.0);
		else 
		    devInfo.devices[currentDev-1].DOFs[dofNo-1].setValue(valNo, 
					(Double.valueOf( val )).doubleValue());
		valNo++;
	    }
	    devInfo.devices[currentDev-1].DOFs[dofNo-1].setNumbValues( valNo );
	    //if( DEBUG )
	//	devInfo.devices[currentDev-1].DOFs[dofNo-1].printDof();
	}
      }
      if (reconfig && newdevserv)
      {
	  camint.reconfigure(devInfo);
	  newdevserv = false;
      }
      if (reconfig)
          camint.updateStatus(devInfo);
      return 1;
  }

  private void processLine1( String line ) throws CamClntMsgFormatException {
      StringTokenizer stline = new StringTokenizer( line, " " );
      if( stline.countTokens() != 3 ) {
	  System.out.println("Something odd, line 1 has " + stline.countTokens()
		 + " tokens");
	  throw new CamClntMsgFormatException( "line 1 too few fields" );
      }
      if( DEBUG )
	  System.out.println( "Message length = " + stline.nextToken() );
      else
	  stline.nextToken();
      long tempTime = Long.parseLong( stline.nextToken() );
      String tempServName = stline.nextToken();
      devInfo = (DevservInfo)devservHash.get( tempServName );
      if( devInfo == null ){
	  devInfo = new DevservInfo( );
	  devservHash.put( tempServName, devInfo );
	  if( DEBUG )
	      System.out.println("Needed to add a new hash table entry for " 
		+ tempServName );
	  newdevserv = true;
      }
      devInfo.lastTimestamp = tempTime;
      camint.comm.updateLasttime( tempTime );
      devInfo.setServerName( tempServName );
      if (DEBUG)
	  System.out.println("Server = " + devInfo.getServerName() 
		+ ", last timestamp = " + devInfo.lastTimestamp);
  }

  private void processLine2(String line) throws CamClntMsgFormatException {
      StringTokenizer stline = new StringTokenizer( line, " " );
      if( stline.countTokens() != 1 ) {
	  System.out.println("Something odd, line 2 has " + stline.countTokens()
		 + " tokens");
	  throw new CamClntMsgFormatException("line 2 wrong number of fields");
      }
      if( DEBUG )
	  System.out.println( "Message Type: " + stline.nextToken());
  }

  private void processLine3(String line) throws CamClntMsgFormatException 
  {
      // Line is in format: "description" version <feature1@feature2...>

      /* Separate string by delimiter '"'; there must be 2 such tokens.  The 
         first token is the devserv description, so call setDescription() for 
         this value.  The second token has the version and an optional set of 
         features.  Parse this token separately, setting version and features 
         according to what is given. 
      */
      StringTokenizer stline = new StringTokenizer( line, "\"" );
      if (stline.countTokens() != 2) {
	  System.out.println("Something odd--line 3 has " + stline.countTokens()		 + " tokens");
	  throw new CamClntMsgFormatException("line 3 wrong number of fields");
      } 
      devInfo.setDescription( stline.nextToken());
      if (DEBUG)
	  System.out.println("Devserv description: " 
		+ devInfo.getDescription());
      // Get the second token and use whitespace as the delimiter.
      String token2 = stline.nextToken();
      StringTokenizer st = new StringTokenizer(token2);
      devInfo.setVersion(st.nextToken());
      if (DEBUG) 
          System.out.println("version is " + devInfo.getVersion());  
      // Test whether there are any more tokens.  If there are more tokens,
      // devserv supports at least 1 additional feature.
      if (st.hasMoreTokens())
      {
	  StringTokenizer st2 = new StringTokenizer(st.nextToken(),"@");
	  while (st2.hasMoreTokens())
		devInfo.setDevservFeatures(st2.nextToken());
      }
      if (DEBUG)
	  System.out.println("Devserv features: " 
		+ devInfo.getDevservFeatures());
  }

  private void processLine4( String line ) throws CamClntMsgFormatException {
      StringTokenizer stline = new StringTokenizer( line, " " );
      if( stline.countTokens() != 2 ) {
	  System.out.println("Something odd, line 4 has " + stline.countTokens()
		 + " tokens");
	  throw new CamClntMsgFormatException("line 4 wrong number of fields");
      }
      devInfo.setMediaInfo( stline.nextToken());
      devInfo.setMediaHost( stline.nextToken());
      if( DEBUG )
	  System.out.println( "Video address: " + devInfo.getMediaInfo() +
			      " media host : " + devInfo.getMediaHost());
  }
  private void processLine5( String line ) throws CamClntMsgFormatException {
      StringTokenizer stline = new StringTokenizer( line, "\"" );
      if( stline.countTokens() != 2 ) {
	  System.out.println("Something odd, line 5 has " + stline.countTokens()
		 + " fields");
	  throw new CamClntMsgFormatException("line 5 wrong number of fields");
      }
      if( DEBUG )
	  System.out.println( "Last Command: " + stline.nextToken());
      else
	  stline.nextToken();
      stline.nextToken(" ");
      if( stline.countTokens() != 2 ) {
	  System.out.println("Something odd, line 5 has " 
		+ (1+stline.countTokens()) + " fields");
	  throw new CamClntMsgFormatException("line 5 wrong number of fields");
      }
      devInfo.setLastCmdHost( stline.nextToken());
      long temptime = Long.parseLong( stline.nextToken());
      if( DEBUG )
	  System.out.println("From : " + devInfo.getLastCmdHost() +
			      "  At time : " + temptime );
      camint.comm.updateLasttime( temptime );
  }

  public DevservInfo getDevservInfo( String name ) {
      return (DevservInfo)devservHash.get( name );
  }

  public Hashtable getDevservHash() { return devservHash; }
}

