/**  This class will keep track of the current information about the
  *  device server.  It will also handle parsing the messages that come in from
  *  the device server.  It will break the message down into its
  *  component parts and store them in variables so that it can answer
  *  later queries about the device server.
  */
package CamClnt;

import java.util.*;

public class DevservInfo {

  /** define a class that describes a particular degree of
    * freedom for a device
    */
  public class DegreeOfFreedom {
    // define the variables that describe a degree of freedom
    protected String name = "";
    protected String feature = null;
    protected int    numbVals;
	
    /* This array stores the movement info for the degree of freedom.  The info
       is normally current position, lower and upper position limits, current
       velocity, lower and upper velocity limits, current acceleration, and
       lower and upper acceleration limits in that order.
    */		
    protected double moveInfo[] = new double[8];  // this array stores the movement info

    // define the method for clearing the variable when changing servers
    public void clear() {
	name = "";
	for( int i=0; i < 8; i++ ) {
	    moveInfo[i] = 0.0;
	}
    }

    // define the methods for setting and extracting movement info
    public void setValue( int index, double newValue ) {
	moveInfo[index] = newValue;
    }
    public double getValue( int index ) {
	return (moveInfo[index]);
    }
    public double getCurrentPosn( ) {
	return moveInfo[0];
    }
    public void setNumbValues( int temp ) {
	numbVals = temp;
    }

    // define methods for setting and getting the name of the degree of freedom
    public void setName( String temp ) {
	name = temp;
    }
    public String getName() {
	return name;
    }
    
    // some degrees of freedom have multiple features.  The next two methods 
    // provide the means of setting and getting the feature.
    public void setFeature( String temp ) {
	feature = temp;
    }
    public String getFeature() {
	return feature;
    }

    public void printDof() {
	if( feature != null )
	    System.out.println("Degree of freedom named " + name 
		+ " with feature " + feature );
	else
	    System.out.println( "Degree of freedom named " + name );
	for( int i=0; i < numbVals; i++ ) 
	    System.out.println( "\t val " + i + " is " + moveInfo[i]);
    }
  }

  // define a class to describe a particular device
  public class DeviceInfo {
    // define the variables that describe a device
    protected String type = "";
    protected int unitNumber = 0;
    private String unitDescription = "";
    private int numbDOFs = 0;
    public  DegreeOfFreedom DOFs[];

    // define methods for setting and getting each of the variables 
    public void setType( String temp ) {
	type = temp;
    }

    public String getType() {
	return type;
    }

    public void setUnitNumber( int temp ) {
	unitNumber = temp;
    }

    public int getUnitNumber() {
	return unitNumber;
    }

    public void setUnitDescription( String temp ) {
	unitDescription = temp;
    }

    public String getUnitDescription() {
	return unitDescription;
    }

    public void setNumbDOFs( int temp ) {
	numbDOFs = temp;
	DOFs = new DegreeOfFreedom[temp];
	for( int i=0; i< temp; i++ )
	    DOFs[i] = new DegreeOfFreedom();
    }

    public int getNumbDOFs() {
	return numbDOFs;
    }

    public void print() {
	System.out.println("Info for " + type + " number " + unitNumber 
		+ " described as a " + unitDescription);
	System.out.println("\tDevice has " + numbDOFs + " degrees of freedom");
    }

    // find the degree of freedom specified
    public DegreeOfFreedom getDOF( String name ) {
	for( int i = 0; i < numbDOFs; i++ ) {
	    if( name.equalsIgnoreCase( DOFs[i].getName()))
		return DOFs[i];
	}
	return null;
    }
    // find the degree of freedom specified by name and feature
    public DegreeOfFreedom getDOF( String name, String feature ) {
	for( int i = 0; i < numbDOFs; i++ ) {
	    if( name.equalsIgnoreCase( DOFs[i].getName()) && 
		feature.equalsIgnoreCase( DOFs[i].getFeature()))
		return DOFs[i];
	}
	return null;
    }
  }

  // define the variables
  public String serverName;
  public long   lastTimestamp;
  public String description;  // text description of devserv 
  public String version;      // devserv version number
  // store the optional features supported by devserv (e.g., CIF, Akenti)
  public Vector devservFeatures = null;  
  public String mediaAddr;
  public String mediaHost;
  public String lastCmdHost;
  public  int  numDevices;
  public  DeviceInfo devices[];
  private static final boolean DEBUG = false; // to get debugging printouts

  // define the constructor.  This method will initiate the object
  // with a default set of values.
  DevservInfo( ) 
      {
      }

  /** define method for setting the serverName
    */
  public void setServerName( String temp ) {
      serverName = temp;
  }

  /** define method for getting the serverName
    */
  public String getServerName() {
      return serverName;
  }

  /** define method for comparing two serverNames
    */
  public boolean isSameServerName( String temp ) {
      // DEB: need to revise this to check also if the addresses are equal even
      // if they are specified 2 different ways.
      return serverName.equalsIgnoreCase( temp );
  }

  /** define method for setting the description
    */
  public void setDescription( String temp ) {
      description = temp;
  }

  /** define method for getting the description
    */
  public String getDescription() {
      return description;
  }

  /** define method for setting the devserv version number.
    */
  public void setVersion(String vers) {
      version = vers;
  }

  /** define method for getting the devserv version number.
    */
  public String getVersion() { 
      return version; 
  }

  /** define method for setting the features supported by devserv.
    */
  public void setDevservFeatures(String s)
  {
      if (devservFeatures == null)
	 devservFeatures = new Vector(1);
      // If the feature is already in the list, don't add it again.  
      if (!devservFeatures.contains(s))
         devservFeatures.addElement(s);
  }

  /** define method for getting the features supported by devserv.
    */
  public Vector getDevservFeatures() { return devservFeatures; }

  /** define method for setting the media address/port/ttl info
    */
  public void setMediaInfo(String temp) { 
	mediaAddr = temp; 
  }

  /** define method for getting the media info as address/port/ttl
    */
  public String getMediaInfo() { return mediaAddr; }

  /** define method for getting the media address
    */
  public String getMediaAddr() {
      int addrend = mediaAddr.indexOf( "/" );
      return (mediaAddr.substring( 0, addrend ));
  }      

  /** define the method for getting the media port
    */
  public int getMediaPort() {
      int addrend = mediaAddr.indexOf( "/" );
      int portend = mediaAddr.indexOf( "/", addrend+1 );
      String temp = mediaAddr.substring( addrend+1, portend );
      return (Integer.parseInt( temp ));
  }

  /** define the method for getting the media ttl
    */
  public int getMediaTTL() {
      int portend = mediaAddr.lastIndexOf( "/" );
      String temp = mediaAddr.substring( portend+1 );
      return (Integer.parseInt( temp ));
  }

  /** define method for setting the mediaHost
    */
  public void setMediaHost( String temp ) { mediaHost = temp; }

  /** define method for getting the mediaHost
    */
  public String getMediaHost() {
      return mediaHost;
  }

  /** define method for setting the lastCmdHost (address that last devserv command came from)
    */
  public void setLastCmdHost( String temp ) { lastCmdHost = temp; }

  /** define method for getting the lastCmdHost
    */
  public String getLastCmdHost() { return lastCmdHost; }

  /** define the method for getting the number of a particular type of device.
    * The type of device is defined by the input argument string 'match'.
    */
  public int getNumberDevices( String match, int numbsignificant ) {
      int numdevs = 0;
      for( int i = 0; i < numDevices; i++ ){
	  if ((devices[i].getType()).regionMatches(
		true,0,match,0,numbsignificant)) {
	      numdevs++;
	  }
      }
      return numdevs;
  }

  public void setDeviceNumber( int number ) {
      numDevices = number;
      devices = new DeviceInfo[number];
      for( int i = 0 ; i < number; i++ )
	  devices[i] = new DeviceInfo();
  }
  public int getNumberDevices() {
      return numDevices;
  }
    
  // find the structure that contains the information for a particular device
  public DeviceInfo getDevice( String type, int number ) {
      for( int i = 0; i < numDevices; i++ ) {
	  if ((devices[i].getType()).equals(type) && 
		(devices[i].getUnitNumber()) == number )
	      return devices[i];
      }
      return null;
  }
}

