/** Define the menubar class for the Remote Camera
  * Interface.  
  */

package CamClnt;

import java.awt.*;
import java.awt.event.*;

public class CamMenu extends MenuBar implements ActionListener {

  /** create a class for use in creating the pull-down menu items
    * that happen when any item in the menubar is chosen.
    */
    class MyMenuItem extends MenuItem {
	public MyMenuItem (String s, ActionListener al ) {
	    super( s );
	    addActionListener( al );
	}
    }

    // define variables for the class
  //Frame parent;
    Window abw = new AboutWindow();
    Window infow = new InfoWindow();
    private static final boolean DEBUG = false;

  /** the constructor for the menu.  It defines the submenus of the menubar.
    */
    public CamMenu( ) {
	super();

	//parent = temp;
	// the file item on the menubar for functions like quit and save
	Menu file = new Menu( "File", true );
	file.add( new MyMenuItem( "Quit", this ));

	// the settings menu for parameter setting changes
	// right now this menu is blanked out for the release since it has
	// not been implemented.
	Menu settings = new Menu( "Settings", true );
	settings.add( new MyMenuItem( "Camera Server Host", this ));
	settings.add( new MyMenuItem( "Multicast address", this ));
	settings.add( new MyMenuItem( "Multicast port", this ));

	// the help menu for obtaining help and version info
	Menu help = new Menu( "Help", true );
	help.add( new MyMenuItem( "About", this ));
	help.add( new MyMenuItem( "Info", this ));

	// add the menus to the menubar
	this.add( file );
	//this.add( settings );
	this.add( help );
	this.setHelpMenu( help );
    }

  /** this method is called any time a menu item is selected.
    */    
    public void actionPerformed( ActionEvent e ) {
	if( e.getActionCommand().equals( "Quit" )) {
	    System.exit( 0 );
	}
	if( e.getActionCommand().equals( "About" )) {
	    abw.setVisible( true );
	}
	if( e.getActionCommand().equals( "Info" )) {
	    infow.show();
	}
	if( DEBUG )
	  System.out.println( "User selected " + e.getActionCommand());
	
	if( e.getSource() instanceof ItemSelectable ) {
	    ItemSelectable is = (ItemSelectable)e.getSource();
	    if( DEBUG) 
	      System.out.println( "The value is: " + (is.getSelectedObjects().length != 0 ));
	}
    }

  class AboutWindow extends Frame implements ActionListener {
      // this class defines the window displayed when the user wants to get info about 
      // this program.

      AboutWindow( ) {
	  super();
	  TextArea aboutText = new TextArea("camInterface\n ",14,40,TextArea.SCROLLBARS_NONE );
	  aboutText.append("version 0.3\n ");
	  aboutText.append( "by Deb Agarwal\n\n ");
	  aboutText.append( "Package = CamClnt\n\n ");
	  aboutText.append( "This program provides the GUI for \n");
	  aboutText.append( "requesting position changes of a remote \n");
	  aboutText.append( "camera system being driven by devserv\n\n");
	  aboutText.append( "To obtain the latest version of the camInterface\n");
	  aboutText.append( "and devserv software check\n");
	  aboutText.append( "http://www-itg.lbl.gov/mbone/devserv\n");
	  aboutText.setEditable( false );
	  add( "North", aboutText );
	  Button dismiss = new Button( "Dismiss" );
	  dismiss.addActionListener( this );
	  add( "South", dismiss );
	  setLocation( 60, 100 );
	  pack();
      }
      
      public void actionPerformed( ActionEvent e ) {
	  if( e.getID() == Event.WINDOW_DESTROY ) {
	      dispose();
	      return;
	  }
	  else if (e.getActionCommand().equals("Dismiss")) {
	      setVisible( false );
	  }
	  super.processEvent( e );
	  return;
      }
  }

  class InfoWindow extends Frame implements ActionListener {
      // this class defines the window displayed when the user wants to get help in running
      // this program.

      InfoWindow( ) {
	  super();
	  TextArea aboutText = new TextArea( "camInterface\n ",34,70,TextArea.SCROLLBARS_NONE );
	  aboutText.append( "version 0.3\n ");
	  aboutText.append( "by Deb Agarwal\n\n ");
	  aboutText.append( "This program provides the GUI for requesting position\n");
	  aboutText.append( "changes of a remote camera system being driven by\n");
	  aboutText.append( "devserv.  To run the interface for a server with more\n");
	  aboutText.append( "than 1 camera specify the number of cameras as an argument\n");
	  aboutText.append( "on startup\n\n");
	  aboutText.append( "The interface - The field at the bottom of the interface is\n");
	  aboutText.append( "used to specify the machine name of the machine running the\n");
	  aboutText.append( "device server (devserv). The large rectangle on the left represents\n");
	  aboutText.append( "the entire pan/tilt space of the camera's range.  If you\n");
	  aboutText.append( "select anywhere in this rectangle, the current camera will\n");
	  aboutText.append( "be driven to the requested absolute position.  The square\n");
	  aboutText.append( "on the right represents the camera view itself.  Pressing\n");
	  aboutText.append( "the left mouse button in this area will cause the camera to\n");
	  aboutText.append( "center the position clicked.  If you press and hold down the\n");
	  aboutText.append( "left mouse button while drawing out a rectangle the camera\n");
	  aboutText.append( "will zoom in on the area drawn out.  The right mouse button\n");
	  aboutText.append( "in this area is used to request picture-in-picture (It will\n");
	  aboutText.append( "only work if you have a pnp capable video switcher attached\n");
	  aboutText.append( "to the server and multiple cameras.)  To request a picture-in-picture\n");
	  aboutText.append( "(pnp) draw out a rectangle while holding the right mouse button and\n");
	  aboutText.append( "the specified pnp camera will appear in the drawn out rectangle.\n");
	  aboutText.append( "To turn off pnp press the right mouse button once in the\n");
	  aboutText.append( "camera image area.  You can also request an absolute zoom by\n");
	  aboutText.append( "using the slider on the bottom of the interface.  The zoom in\n");
	  aboutText.append( "and out buttons will step 1x zoom each time they are pressed.\n\n");
	  aboutText.append( "If you started up the interface with more than one camera then\n");
	  aboutText.append( "you will see selection boxes for choosing the camera to view, \n");
	  aboutText.append( "the camera to move and the camera to put in the pnp.\n");
	  aboutText.append( "\n");
	  aboutText.setEditable( false );
	  add( "North", aboutText );
	  Button dismiss = new Button( "Dismiss" );
	  dismiss.addActionListener( this );
	  add( "South", dismiss );
	  setLocation( 60, 100 );
	  pack();
      }
      
      public void actionPerformed( ActionEvent e ) {
	  if( e.getID() == Event.WINDOW_DESTROY ) {
	      dispose();
	      return;
	  }
	  else if (e.getActionCommand().equals("Dismiss")) {
	      setVisible( false );
	  }
	   super.processEvent( e );
	   return;
      }
  }
}
	
