//  This class will handle the communication with the camera 
//  server and will add the header to messages going to the
//  camera server.  It will also handle all incoming communication from
//  the camera server.
package CamClnt;

import java.io.*;
import java.util.*;

public class CamComm extends GenComm {
  // define the variables
    boolean       connected = false;
    camInterface  camint;
    String        devservHost;
    int           tempindex;
    long          lasttime = 0;
    private static final boolean DEBUG = false; // to get debugging printouts
    //boolean akenti = false, cif = false;

    // define the constructor.  The call to super will open the connection
    CamComm(camInterface caller, String address, int port, String type) 
	throws IOException 
    {
      this( caller, address, port, type, false, false );
    }

    // define the constructor.  The call to super will open the connection
    CamComm(camInterface caller, String address, int port, String type, 
	boolean useAkenti, boolean useCIF) throws IOException 
    {
	super(type, address, port, useAkenti, useCIF);

	// The line below won't work--gives error that we can't
	// reference 'akenti' and 'cif' before super() gets called.
	// super( type, address, port, akenti, cif );

	if( type == "UDP" || type == "TCP" )
	  devservHost = address;
	camint = caller;
	if( address != "Invalid" )
	  connected = true;
	if (DEBUG)
	  System.out.println("Connected for addr " + address + " port " + port 
		+ " type " + type); 
    }

  /** write a camera control string to the device server.
    * This method expects the ASCII camera command text to be passed in. It adds
    * line 1 and then writes the command to the camera controller.
    */
  public int writeCamString( String actmov ) {
      // the actmov string passed in has the command information
      // for moving the camera but still needs line 1 and the camera
      // number portion of the command added.
      String command = getLineOne() + "cam " + camint.getCurrentCamera() + " " 
		+ actmov;
      if (DEBUG)
	  System.out.println("Sending: " + command );
      try
	{
	  if (connected)
	    writeString( command, camint.addressField.getText() );
	}
      catch( IOException e)
	{
	  connected = false;
	  camint.addressField.setText( "Invalid" );
	}
      return 0;
  }

  // this method creates and returns a string containing the information 
  // for line one of the command
  private String getLineOne() {
      long temp = System.currentTimeMillis();
      if( temp < lasttime )
	  temp = lasttime + 1;
      lasttime = temp;
      return (temp + " " + camint.addressField.getText() + "#");
  }

  /** write a video switcher command to the device server.
    * The argument passed in is the video switcher command the routine adds
    * line 1 and writes the command to the camera controller.
    */
  public int writeVidString( String actmov ) {
      // the actmov string passed in gives the video switcher command
      // information for moving the video switcher to a different camera.
      String command = getLineOne() + "vid 1 " + actmov;
      if( DEBUG )
	  System.out.println("Sending: " + command );
      try
	{
	  if( connected )
	    writeString( command, camint.addressField.getText() );
	}
      catch( IOException e )
	{
	  connected = false;
	  camint.addressField.setText( "Invalid" );
	}
      return 0;
  }

  /** write a video switcher picture-in-picture command to the device server.
    * 
    */
  public int writePnpString( String actmov ) {
      // send a picture in picture turn on or off request
      String command;
      if ( camint.pict.pnpIsOn() ) {
	  if (actmov.equalsIgnoreCase( "" ))
	      // this is a command to switch which camera is in the 
              // picture-in-picture
	      command = "pnp cam " + camint.getPnpCamera();
	  else
	      command = "pnp cam " + camint.getPnpCamera() + "@" + actmov;
      }
      else if (actmov.equalsIgnoreCase( "off" ))
	// turn off picture-in-picture
	  command = "pnp sta off";
      else
	  return 0;

      return writeVidString( command );
  }

  /** Read the status or description message sent by the server This
    * message will come in as a multicast from the machine that is
    * actually running the cameras.
    */
  public int readCamString( int timeout ) {
      if( !connected ) 
	return -1;
      String msg = readString( timeout );
      if( msg == null )
	return 0;
      tempindex = 0;
      if( DEBUG )
	System.out.println( "Message received: " + msg);
      while( tempindex != -1 ) {
	String currentLine = getNextSubString( msg, "#" );
	if( DEBUG )
	  System.out.println( "msgindex= " + tempindex + ": " + currentLine);
	int nextline = tempindex;
	tempindex = 0;
	while( tempindex != -1 ) {
	  String currentSub = getNextSubString( currentLine, "@" );
	  if( DEBUG )
	    System.out.println( "Substring: " + currentSub );
	}
	tempindex = nextline;
      }
      return 1;
  }

  // Get the next line of the message passed in.  The message is
  // passed in as a string and the index to start looking for the
  // beginning of the line in the string is stored in index.
  // The character delimiting the string is passed in as the last
  // argument.
  private String getNextSubString( String msg, String delimiter ) {
      if( DEBUG )
	System.out.println("getNextSubString: index= " + tempindex 
		+ "delimiter = " + delimiter);
      int begindex = tempindex;
      if( begindex == -1 )
	  return null;
      int endOfLine = msg.indexOf( delimiter, begindex );
      if( endOfLine == -1 ) {
	  tempindex = -1;
	  return msg.substring( begindex );
      }
      tempindex = endOfLine + 1;
      if( DEBUG )
	System.out.println("getNextSubString3: index= " + tempindex 
		+ "delimiter = " + delimiter);
      return msg.substring( begindex, endOfLine );
  }
    
    public void updateLasttime( long newtime ) {
	if( newtime > lasttime )
	    lasttime = newtime;
    }
}

