/* Copyright (c) 1998 Regents of the University of California.
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *       This product includes software developed by the Imaging and
 *       Distributed Collaboration Group at Lawrence Berkeley 
 *       National Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: network.cc,v 0.4.3 98/14/10 16:28:31 mperry Exp $ (LBL)
*/

#include "network.h"


Network::Network(int fd, int s, short p)
{
    sock = fd;
    seconds = s;	
    port = p;
    memset(&peer, 0, sizeof(peer));	
}

Network::~Network()
{
    close(sock);
}

void Network::setPort(short p)
{
    port = p;
}

void Network::getLocalname(char *host)
{
#ifdef __sun__ 
    sysinfo(SI_HOSTNAME, host, (long)257);
    struct hostent *hp = gethostbyname(host);
    if (hp)
	strcpy(host, hp->h_name);
#else
    char buf[256];
    gethostname(buf,256);
    strcpy(host, buf);
#endif
}
       
	
int Network::doSend(const char *msg, long len)
{
    long n;

    if ((debugLevel==2) || (debugLevel==4))
      printf("Network::doSend--msg: %s, sock: %d\n",msg,sock);
    n = sendto(sock, msg, len, 0, (struct sockaddr *)&peer, sizeof(peer));
    if ((debugLevel==2) || (debugLevel==4))
      printf("Network::doSend--sendto() ret'd %ld\n", n);
    if ((n < 0) && (debugLevel > 0))
	perror("Network: sendto()");
    else if ((n < len) && (debugLevel > 0))
	printf("Network: sendto() didn't send whole message\n");
    if ((debugLevel==2) || (debugLevel==4))
        printf("Network::doSend--returning %ld\n", n);
    return n; 	
}
     

int Network::doRecv(char *buf, long len)
{
    int l, n;
    struct timeval t;      
    fd_set fd;

    t.tv_sec = seconds;
    t.tv_usec = 0;
    FD_ZERO(&fd);
    FD_SET(sock, &fd);
    n = select(sock+1, &fd, NULL, NULL, &t);
    if (n > 0)
    {
	l = sizeof(peer);
	n = recvfrom(sock, buf, len, 0, (struct sockaddr *)&peer, &l);
        if ((debugLevel==2) || (debugLevel==4))
	   printf("Network::doRecv--recvfrom returned %d\n",n);
	if (n < 0) 
	{	
	     if (debugLevel > 0)
	     	perror("Network: recvfrom() failed");	
	}
	else
	     buf[n] = '\0';
	if (n > 0)
	     n++;	
    }
    if ((debugLevel==2) || (debugLevel==4))
        printf("Network::doRecv--returning %d\n", n);
    return n;
}			
  
