// -*- C++ -*-
#ifndef MATH_ITERATOR_H
#define MATH_ITERATOR_H

#include "math_cursor.h"

// this helper struct is used for traversing math insets

class MathIterator {
public:
	/// default constructor, used for end of range
	//MathIterator();
	/// start with given inset
	explicit MathIterator(MathInset * p);
	/// start with given position
	//explicit MathIterator(MathCursor::cursor_type const & cursor);
	///
	MathCursorPos const & operator*() const;
	///
	MathCursorPos const & operator->() const;
	/// move on one step
	void operator++();
	/// move on several steps
	void jump(MathInset::difference_type);
	/// read access to top most item (inline after running gprof!)
	MathCursorPos const & position() const { return cursor_.back(); }
	/// write access to top most item
	MathCursorPos & position() { return cursor_.back(); }
	/// read access to full path
	MathCursor::cursor_type const & cursor() const;
	/// read access to top most inset
	MathInset const * par() const;
	/// read access to top most inset
	MathInset * par();
	/// helper for iend
	void goEnd();
	/// read access to top most item
	MathArray const & cell() const;

private:
	/// own level down
	void push(MathInset *);
	/// own level up
	void pop();

	/// current position
	MathCursor::cursor_type cursor_;
};

///
bool operator==(MathIterator const &, MathIterator const &);
///
bool operator!=(MathIterator const &, MathIterator const &);

///
MathIterator ibegin(MathInset * p);
///
MathIterator iend(MathInset * p);

#endif
