// -*- C++ -*-
/**
 * \file Tooltips.h
 * Copyright 2002 the LyX Team
 * Read the file COPYING
 *
 * \author Angus Leeming, a.leeming@ic.ac.uk
 */

/* Tooltips for xforms. xforms 0.89 supports them directly, but 0.88 needs
 * a bit of jiggery pokery. This class wraps it all up in a neat interface.
 * Based on code originally in Toolbar_pimpl.C that appears to have been
 * written by Matthias Ettrich and Jean-Marc Lasgouttes.
 */

#ifndef TOOLTIPS_H
#define TOOLTIPS_H

#include "LString.h"
#include <boost/utility.hpp>
#include <sigc++/signal_system.h>
#include <map>
#include FORMS_H_LOCATION // Can't forward-declare FL_OBJECT

#ifdef __GNUG__
#pragma interface
#endif

class Tooltips : boost::noncopyable, public SigC::Object {
public:
	Tooltips();

	/// Initialise a tooltip for this ob.
	void init(FL_OBJECT * ob, string const & tip);

	/// Are the tooltips on or off?
	static bool enabled() { return enabled_; }

	/// This method is connected to the tooltipsToggled signal.
	void set();

#if FL_REVISION < 89

	/** Return the tooltip associated with this object.
	 *  Required by an xforms callback routine.
	 */
	string const get(FL_OBJECT *) const;

#endif

private:

	/// Are the tooltips on or off?
	static bool enabled_;

	/** This method is connected to Dialogs::toggleTooltips and toggles
	 *  the state of enabled_.
	 */
	static void toggleEnabled();

	/** Once enabled_ is changed, then this signal is emitted to update
	 *  all the tooltips.
	 */
	static SigC::Signal0<void> toggled;

	/// The tooltips are stored so that they can be turned on and off.
	typedef std::map<FL_OBJECT *, string> TooltipsMap;

	TooltipsMap tooltipsMap;

#if FL_REVISION < 89

	/** A timer is started once the mouse enters an object, so that the
	 *  tip appears a short delay afterwards.
	 */
	FL_OBJECT * tooltip_timer_;

#endif
};

#endif // TOOLTIPS_H
