// -*- C++ -*-
/* This file is part of
 * =================================================
 * 
 *          LyX, The Document Processor
 *          Copyright 1995 Matthias Ettrich.
 *          Copyright 1995-2000 The LyX Team.
 *
 * ================================================= 
 *
 * \author Michael Koziarski <michael@koziarski.org>
 * */

#ifndef GTABULARCREATE_H
#define GTABULARCREATE_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlTabularCreate.h"
#include "GnomeBase.h"

namespace Gtk {
class SpinButton;
}

/**
 * This class implements the dialog to insert/modify urls.
 */
class GTabularCreate : public FormCB<ControlTabularCreate> {
public:
	///
	GTabularCreate(ControlTabularCreate & c);
	///
	~GTabularCreate();

	void apply();
	
private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;
	void update();

	void OKClicked() { OKButton(); }
	void CancelClicked() { CancelButton(); }
	void ApplyClicked() { ApplyButton(); }

	/// generated by accessors.py
	Gtk::Button * ok_btn() const;
	/// generated by accessors.py
	Gtk::Button * apply_btn() const;
	/// generated by accessors.py
	Gtk::Button * cancel_btn() const;
	/// generated by accessors.py
	Gtk::SpinButton * rows() const;
	/// generated by accessors.py
	Gtk::SpinButton * cols() const;

};

#endif
