// -*- C++ -*-
/* This file is part of
 * =================================================
 * 
 *          LyX, The Document Processor
 *          Copyright 1995 Matthias Ettrich.
 *          Copyright 1995-2000 The LyX Team.
 *
 * ================================================= 
 *
 * \author Michael Koziarski <michael@koziarski.org>
 * */

#ifndef GERT_H
#define GERT_H

#ifdef __GNUG__
#pragma interface
#endif

#include "ControlERT.h"
#include "GnomeBase.h"

namespace Gtk {
	class RadioButton;
	class Button;
}

/**
 * This class implements the dialog to insert/modify urls.
 */
class GERT : public FormCB<ControlERT> {
public:
	///
	GERT(ControlERT & c);
	///
	~GERT();

	void apply();
	void update();
	
private:
	/// Build the dialog
	void build();

	/// Returns true if the dialog input is in a valid state.
	bool validate() const;

	/// Do the connection of signals
	void connect_signals();
	/// Disconnect the signals.
	void disconnect_signals();

	/// generated by accessors.py
	Gtk::Button * ok_btn() const;
	/// generated by accessors.py
	Gtk::Button * apply_btn() const;
	/// genearated by accessors.py
	Gtk::Button * cancel_btn() const;
	/// generated by accessors.py
	Gtk::RadioButton * open() const;
	/// generated by accessors.py
	Gtk::RadioButton * collapsed() const;
	/// generated by accessors.py
	Gtk::RadioButton * inlined() const;
	

	/// do input validation
	SigC::Connection slot_open;
	SigC::Connection slot_collapsed;
	SigC::Connection slot_inlined;

};

#endif
