/* -*- C++ -*- */
/* This is the compilation configuration file for LyX. It was generated by 
   autoconf's configure. You might want to change some of the defaults if 
   something goes wrong during the compilation
   
   * This file is part of
   * ======================================================
   *
   *           LyX, the High Level Word Processor
   *
   *           Copyright 1995 Matthias Ettrich
   *           Copyright 1995-2001 The LyX Team.
   *
   *======================================================*/

#ifndef _CONFIG_H
#define _CONFIG_H

@TOP@

/* define this to the location of forms.h to be used with #include,
  e.g. <forms.h> */
#undef FORMS_H_LOCATION

/* define this to the location of xpm.h to be used with #include,
  e.g. <xpm.h> */
#undef XPM_H_LOCATION

#undef HAVE_LIBSM

/* Define as 1 if the MKSTEMP function is declared */
#undef HAVE_DECL_MKSTEMP

/* Define if you have the function prototype for snprintf().  */
#undef HAVE_DECL_SNPRINTF

/* Define if you have the function prototype for vsnprintf().  */
#undef HAVE_DECL_VSNPRINTF

/* Define if you have the function prototype istreambuf_iterator in
   <iterator> */
#undef HAVE_DECL_ISTREAMBUF_ITERATOR

@BOTTOM@ 

/************************************************************ 
 ** You should not need to change anything beyond this point */

#ifndef HAVE_STRCHR
#define strchr(a,b)     index(a,b)
#endif

#ifndef HAVE_MEMMOVE
#define memmove(a, b, c)  bcopy(b, a, c)
#endif

#ifndef HAVE_STRERROR
#if defined (__cplusplus)
extern "C"
#endif
char * strerror(int n);
#endif

#ifdef BROKEN_HEADERS
#include "broken_headers.h"
#endif

#ifdef HAVE_MKSTEMP
#ifndef HAVE_DECL_MKSTEMP
#if defined (__cplusplus)
extern "C"
#endif
int mkstemp(char*);
#endif
#endif

/* C++ always support the keyword `inline' */
#if defined inline && defined __cplusplus
/**/#undef inline
#endif

/* C++ always has a good enough `const' */
#if defined const && defined __cplusplus
/**/#undef const
#endif

/* Check on the run if we are using exceptions during this compilation.*/
#if defined(__sgi) || defined(__GNUC__)
#  ifdef __EXCEPTIONS
#    define USING_EXCEPTIONS
#  endif
#endif

#if defined(__USLC__) || defined(__SUNPRO_CC) || defined(__COMO__) || defined(__ICL)
#  define USING_EXCEPTIONS
#endif

#ifdef __EMX__
#include "support/os2_defines.h"
#endif

#if defined(__CYGWIN__) || defined( __CYGWIN32__)
#include "support/nt_defines.h"
#endif

/* Some support for the boost library. */
#ifndef HAVE_LIMITS
#define BOOST_NO_LIMITS
#endif

#ifndef HAVE_SSTREAM
#define BOOST_NO_STRINGSTREAM
#endif

#endif /* _CONFIG_H */

