// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, The Document Processor
 *	     Copyright (C) 1995 Matthias Ettrich
 *        
 *           This file is Copyright (C) 1996-1998
 *           Lars Gullik Bjnnes
 *
 * ======================================================
 */

#ifndef DEP_TABLE_H
#define DEP_TABLE_H

#include "LString.h"
#include <cstdio>

///
class DepTable {
public:
	///
	DepTable();
	///
	/** This one is a little bit harder since we need the absolute
	  filename. Should we insert files with .sty .cls etc as
	  extension? */
	void insert(string const &f,
		    bool upd = false,
		    unsigned long one = 0,
		    unsigned long two = 0);
	///
	void update();

	///
	void write(string const &f);
	///
	void read(string const &f);
	/// returns true if any of the files has changed
	bool sumchange();
	///
	bool haschanged(string const &fil);
private:
	///
	DepTable(string const &f,
		 bool upd,
		 unsigned long one,
		 unsigned long two);
	///
	string file;
	/// The files new checksum
	unsigned long new_sum;
	/// The files old checksum
	unsigned long old_sum;
	///
	DepTable *next;
		
	///
	void write(FILE *f);
};

#endif
