.\" -*- nroff -*-
.\" psfilter.n,v 1.3 1997/12/03 08:47:48 papowell Exp
.ds In /usr/local/lib/filter
.ds BN \*(In/psbanner 
.ds TX \*(In/textps
.ds RV \*(In/psrev
.de TQ
.br
.ns
.TP \\$1
..
.TH PSFILTER 1
.SH NAME
psfilter \- lpr PostScript communication filter
.SH SYNOPSIS
.B psfilter
[
.BI \-T option[,option]*
]*
[
.B -c
]
[
.BI \-s "statusfile"
]
[
.BI \-? lpr_filter_options
]
[
.I accounting_file
]
.sp
.BI psif "    (same options as psfilter)"
.sp
.BI psof "    (same options as psfilter)"
.SH DESCRIPTION
.B psfilter
handles communication with a PostScript printer for lpr output filters.
The PostScript printer must be connected using a bidirectional serial channel;
you can override this by using the
.B -T dev=device
option.
The command-line syntax of
.B psfilter
is such that any argument which
.B lpd
might pass to an output filter is a legal argument for
.BR psfilter .
.LP
The
.B psof
and
.B psif
filters are symbolic links to
.B psfilter .
When invoked as
.B psof ,
the
.B psfilter
program will behave like a
.I vintage
LPR
.I of
filter and use non-whitespace input lines to generate a banner.
When invoked as
.B psfilter
with the
.BI -F format
option having format 'f',
it will also act as an
.I of
filter,
but pass through all input to the output.
The
.I of
filters suspend themselves when a special stop sequence is
seen in the input stream;
they cannot be used to print general files.
.LP
When invoked as
.B psif
or as
.B psfilter
with the
.BI -F format
option and the format is 'f',
.B psfilter
will 
check the input for PostScript or text files.
If the input is a text file then it will invoke
.B textps
to convert the input to a PostScript file.
.SH OPTIONS
.TP
.B -c
.br
(clear) binary input; do not process input file.
.TP
.BI -s statusfile
.br
.B psfilter
updates
.I statusfile
(the contents of which are displayed by lpq)
filter option with the printer's status.
.TP
.B accounting_file
.br
record accounting information in this file.
The accounting information should be reliable except when
the printer has been turned off or disconnected in the middle of a job.
.TP
.BI -T option[,option]*
The following options are available.
.TP
.BI accounting = /pathname_to_executable
When the -Taccounting is specified,
the specified program is executed with the same options as the filter,
with the addtion of:
.ti -5n
.BI -p start_page_counter
.br
The value of the page counter at the start of the job.
.ti -5n
.BI -q start_page_counter
.br
The total number of pages used for the job
.ti -5n
start or end
.br
The start word is added at the job start and the end at the job end.
.BI banner =[off|on*]
When invoked as the OF filter,
interpret input as banner information and generate a banner.
(Default is on).
.TP
.BI debug =level
.br
set debugging level.
The default level is 2; higher values produce more verbose output.
.TP
.BI dev =/device
.br
.BI dev =host%port
.br
Open a connnection to either the device or to the port on the host
and send output to it. 
By default, output is send to stdout.
.TP
.BI endpause =delay
.br
When used as the OF filter,
at the start and end of the job
psfilter will query the printer for the value of the hardware pagecounter.
The difference between the start and end values is reported
as the number of pages used for the job.
Unfortunately,
some printers such as the HP LaserJet 4 and HP LaserJet 5 report the current
value of the page counter at the time of request,
and it is difficult to determine if the last page has been completely printed
by examining returned PostScript status.
Before querying the printer at the end of a job,
the psfilter software will wait
.I endpause
seconds (default is 5).
On a 12 page per minute printer,
this appears to be sufficient to allow the last page to be completely printed.
However,
if the printer jams on the last page, it will still not be reported
and the page count will be off by one.
.TP
.BI forcepagecount =[off*|on]
To find the pagecount value,
a PostScript program is sent to the printer.
This overrides any other flags and forces the
program to be sent.
Usually used in combination with
.I -Tstatus=off
.I -Tforceps,
and
.I -Tnosync
flags.
See the comments below for printer specific problems.
.TP
.BI forceps =[off*|on]
Forces a dummy PostScript job to be sent at the start of operations.
This usually tricks autosensing printers into going into PostScript mode
and responding to the PostScript conventions.
See the comments below for printer specific problems.
.TP
.BI maxresponse =seconds (default 30 seconds)
.br
Specifies how long to wait for a status response before giving
an error indication.
.TP
.BI nosync =[off*|on]
Suppresses trying to get status from the PostScript printer,
as would normally be returned by sending a ^T.
See the comments below for printer specific problems.
.TP
.BI pagecount =[off|on*]
Get the pagecounter value from the printer and use
for accounting information.
Note that some HP printers (LJ4s) do not appear to have pagecounters.
(Default is on).
.TP
.BI reverse =[off*|on]
Reverse page order on output.
.TP
.BI status =[off|on*]
Query the print device for status and page count information.
If status is off,
then psfilter simply formats input into postscript and does not do accounting. 
.TP
.BI stty =stty_options
If the output device is a serial port,
set the configuration according to the stty options.
These options should be identical to those used by
.BR stty (1).
.TP
.BI summary =destination
.br
Write a one line status summary to the destination.
The destination can be a file (i.e. - /tmp/status)
or a UDP port on a host (host%port). The host name can be
an hostname or an IP address (i.e.- info.sdsu.edu%2000 or
130.191.163.56%1000).
.TP
.BI tbcp =[off*|on]
Use the Adobe Tagged Binary Communications protocol to send
the document when invoked as an IF filter.
The OF filter cannot handle binary PostScript documents
as it will remove various control sequences.
The -Ztbcp LPRng option will also enable TBCP operations.
.TP
.BI udp_status_port =host%port
The HP5m and possibly other printers use port 9101 (UDP) to request
and send status.  When sent a UDP packet on this port, the printer
resonds by sending status back to the sender.
This option forces the use of this port for sending status.
However, page counts and other information still use the standard
connection to the printer.
.SH OPERATION
The psfilter first tries to establish communication with a postscript printer,
using the protocol described in the PostScript Language Reference Manual,
Appendix D, by Adobe Systems Inc.
When communication is established,
the current page count is read from the printer;
this may not be implemented on all printers.
If the Tagged Binary Communications Protocol (TBCP) is requested and the
program is used as an IF  filter,
the TBCP start sequence is sent.
Next,
the job is transferred to the printer.
If a text file,
it is converted to PostScript using TEXTPS (see AUXILLARY programs below),
and if page reversal is specified is processed by the REVERSE program
as well.
During transfer the printer is monitored for various activities and
error conditions.
At the end of the transfer,
the total number of pages used is retrieved from the printer
and the TBCP end sequence if required.
.LP
The page count and total number of bytes transferred
is logged to the accounting file,
with an indication of the process ID that generated it.
.LP
If a printer error or alarm condition is detected,
the
.BI syslog (8)
facility is used to report it as an alarm from
.BR LOG_LPR .
.SH OPERATION
.LP
The
.B "BANNER"
compile time variable specifies the pathname of the banner printing
program.
By default this is
\f(CW\*(BN\fP.
.LP
The
.B "TEXTPS"
compile time variable specifies the pathname of the
text to PostScript conversion program.
By default this is
\f(CW\*(TX\fP.
.LP
The
.B "REVERSE"
compile time variable specifies the pathname of the
PostScript page reversal conversion program.
By default this is
\f(CW\*(RV\fP.
.SH "PRINTER SPECIFIC PROBLEMS"
.LP
The psfilter program tries very hard to work with a wide range of printers,
but there are some whose behaviour is not quite as expected.
To deal with these problems, some very strange flags and options can be
used.
.TP
Parallel port printers
or those which do not respond in a normal manner
operation can be connected by using the -Tstatus=off
flag.
This suppresses sending any commands that expect normal PostScript
responses.
.TP
AutoSensing Printers
These printers try to guess the type of job by reading the first couple
of lines of the job file.
To deal with this,  you need to send a dummy PostScript job to the printer
to force the printer into PostScript mode.
The flag combination -Tstatus=off -Tforceps
will force the printer into PostScript mode.
.TP
AutoSensing and PageCounts
If you want to use autosensing,  then you need to force the sending of
a PostScript dummy file,  and then send a small PostScript job to the
printer which will print the page counter value.
The flag combination -Tstatus=off -Tforceps -Tforcepagecount
will do this.
.TP
AutoSensing Printers and Status
It has been observed that some autosensing printers will return erroneous
status for ^T commands.
This may have a catastrophic effect on the psfilter.
If this is the case,  as can be discovered by examining the log information
produced by psfilter,  then the -Tnosync command will cause the ^T
information to be ignored.
.SH "AUTHORS"
.nf
Original Author:
   James Clark <jj@jclark.com>,  used with with his permission;
Modified by:
   Patrick Powell <papowell@sdsu.edu>
.SH "SEE ALSO"
.BR textps (1),
.BR psrev (1),
.BR printcap (5),
.BR lpd (8)
