/***************************************************************************
 * LPRng - An Extended Print Spooler System
 *
 * Copyright 1988-1995 Patrick Powell, San Diego State University
 *     papowell@sdsu.edu
 * See LICENSE for conditions of use.
 * From the original PLP Software distribution
 *
 ***************************************************************************
 * MODULE: psfilter.h
 * PURPOSE:  declare variables
 * psfilter.h,v 1.5 1997/12/18 09:45:47 papowell Exp
 **************************************************************************/

#include "portable.h"

/***************************************************************************
 * define DEBUGVERSION to force a hard wired debugging version
 * you must recompile with this variable.
 ***************************************************************************/
#ifndef EXTERN
#define EXTERN extern
#define DEFINE(X)
#else
#undef EXTERN
#define EXTERN
#define DEFINE(X) X
#endif

/*****************************************************************
 * strncpy/strncat(s1,s2,len)
 * The bsdi-compat versions of strncat and strncpy
 * only copy up to the end of string, and a terminating 0.
 *****************************************************************/

#define safestrncat( s1, s2 ) strncat(s1,s2,sizeof(s1)-strlen(s1)-1)
#define safestrncpy( s1, s2 ) strncpy(s1,s2,sizeof(s1));

EXTERN int errorcode;
EXTERN char *name;		/* name of filter */

EXTERN int debug
#ifdef DEBUGVERSION
  DEFINE( = 10 )
#endif
	;
EXTERN int verbose, width, length, xwidth, ylength, literal, reverse, indent;
EXTERN char *zopts, *class, *job, *login, *accntname;
EXTERN char *controlfile;
EXTERN char *datafile;
EXTERN char *jobnumber;
EXTERN char *host, *accntfile, *format;
EXTERN char *printer DEFINE( = "psfilter" );
EXTERN char *controlfile, *bnrname, *comment;
EXTERN char *queuename;
EXTERN char *errorfile
#ifdef DEBUGVERSION
  DEFINE( = "/tmp/errors" )
#endif
	;
EXTERN int npages;	/* number of pages */
EXTERN int initialpagecount;	/* initial pagecount */
EXTERN char *statusfile;
EXTERN char *summaryfile;	/* additional summary file if needed */
EXTERN char filter_stop[] DEFINE(= { "\031\001" } );
		/* sent to cause filter to suspend */
EXTERN char *device, *stty_str;
EXTERN int End_pause DEFINE( = 5 );
EXTERN int Timeout DEFINE( = 10 );
EXTERN int Max_try;
EXTERN int ReportPSOutput DEFINE( = 0 );
EXTERN int Max_response DEFINE( = 30 );
EXTERN int Filter_pid;	/* pid of process */
EXTERN int New_type;	/* new type of message arrived */
EXTERN int New_status;	/* new status arrived */
EXTERN int Last_status;	/* last status from the status field */
EXTERN int Old_status;	/* previous status from the status field */
EXTERN int Bytecount;	/* total bytes sent */
EXTERN int OFfilter;	/* classical OF filter flag */
EXTERN int IFfilter;	/* classical IF filter flag */
EXTERN int IFfilter;	/* classical IF filter flag */
EXTERN char **Argv_p, **Envp_p;
EXTERN char *Accounting_script;
EXTERN int Use_banner DEFINE( = 1 );	/* use the BANNER program */
EXTERN int Get_status DEFINE( = 1 );	/* get page and status info */
EXTERN int Page_count DEFINE( = 1 );	/* get page count */
EXTERN int Accounting_fd;	/* Accounting fd is 3 if present */
EXTERN int tbcp, tbcp_enabled;	/* Adobe Tagged Binary Comm Protocol */
EXTERN int No_sync;		/* do not do sync */
EXTERN int Force_ps;	/* force PS indicator to be sent */
EXTERN int Force_pagecount;	/* force pagecount to be asked for */
EXTERN char *Udp_status_port;	/* status port for Upd status access */
EXTERN int Udp_status_sock DEFINE( = 1);	/* socket to use for status */

#ifndef BANNER
# define BANNER "/bin/cat"
#endif
#ifndef TEXTPS
# define TEXTPS "/bin/cat"
#endif
#ifndef PSREV
# define PSREV "/bin/cat"
#endif
EXTERN char *Banner DEFINE( = BANNER );
EXTERN char *Psrev DEFINE( = PSREV );
EXTERN char *Textps DEFINE( = TEXTPS );

#define STATUSBUFLEN 1024
EXTERN char statusbuf[STATUSBUFLEN+1];		/* buffer */

#ifdef HAVE_STDARGS
void log( char *msg, ... );
void logerr( char *msg, ... );
void logerr_die( char *msg, ... );
void fatal( char *msg, ... );
void setstatus( char *msg, ... );
int	plp_snprintf (char *str, size_t count, const char *fmt, ...);
int	vplp_snprintf (char *str, size_t count, const char *fmt, va_list arg);
#else
void log();
void logerr();
void logerr_die();
void fatal();
void setstatus();
int plp_snprintf ();
int vplp_snprintf ();
#endif

/*****************************************************************
 * Signal handlers
 * plp_signal(int, plp_sigfunc_t);
 *  SIGALRM should be the only signal that terminates system calls
 *  with EINTR error code ; all other signals should NOT terminate
 *  them.  Note that the signal handler code should assume this.
 *  (Justin Mason, July 1994)
 *  (Ref: Advanced Programming in the UNIX Environment, Stevens)
 * plp_block_signals()
 *  blocks the set of signals used by PLP code; May need this in
 *  places where you do not want any further signals, such as termination
 *  code.
 * plp_unblock_signals() unblocks them.
 *****************************************************************/

extern  plp_sigfunc_t plp_signal (int, plp_sigfunc_t);

extern void banner( void );
extern void cleanup_job( int code );
extern void doaccnt( int start );
extern int writecn ( int fd, char *ptr, int nbytes );
void filter(char *stop, int timeout, int max_try, int max_response );
void suspend( void );

/* utility functions */
char *Time_str();
int Write_fd_str( int fd, char *msg );
int Write_fd_len( int fd, char *msg, int len );
void newstatus( void );
int udp_open( char *device );

/* printer sync functions */

const char * Errormsg ( int err );
int reset_printer( int timeout, int max_try, int max_reponse, int clearit );
int find_status();
int decode_status( char *buf, int type );
int sync_pr( int timeout, int max_try, int sync, int end_job, char *msg,
	int maxresponse, int clear_no_reponse, int wanted_type, int idle,
	int force_ps );
int getpagecount( int timeout, int max_try, int max_response, int endpause,
	int nosync, int force_ps );
void do_status( int interval, int timeout );

/* serial line functions */
void Do_stty( int fd, char *options );

/*
 * decode the return status from the printer
 * This will have the format as described in the PostScript Reference Manual
 *
 * The error message has the following format
 * %%[ KEY1: V1; KEY2: v2 ]%%
 */

struct statusfield{
	char *key;		/* key on line , i.e. - status:*/
	char *value;	/* string after key  */
	int type;		/* type from msg_types */
	int status;		/* status from status_types */
};


struct errorkey {
	char *key;
	int value;
};

/*
 * See the PostScript Language Reference Manual, Appendix D
 *  The PAGECOUNT value is in response to a query message
 */
enum msg_types {
	BAD_MSG = 0, JOB, STATUS, SOURCE, ERROR, PRINTERERROR,
	FLUSHING, EXITSERVER, PAGECOUNT, UNKNOWN
};

enum status_types {
	BAD_STATUS = 0, IDLE, BUSY, WAITING, PRINTING, PRINTERROR, INITIALIZING
};

EXTERN struct statusfield fields[10];
EXTERN int fieldcount;
EXTERN int Statuspid;
EXTERN int ReversePid;
EXTERN int TextPid;

/**************************************************************************
 * special printer chars
 **************************************************************************/
 
#define CTRL_C  (003)
#define CTRL_D  (004)
#define CTRL_T  (024)
#define ESC     (033)



#define SMALLBUFFER 512
