#include "psfilter.h"
#include "portable.h"
#include "errorcodes.h"

#define FILTABORT	JABORT
/*
 *  doaccnt()
 *  writes the accounting information to the accounting file
 *  This has the format: user host printer pages format date
 */

static int argc;
static char *parms[20];
static char list[1024];
static char list2[1024];

void inv( char *key, char *value )
{
	int len, len2;
	len = strlen( list );
	len2 = strlen( list2 );
	if( value && *value ){
		if( key ){
			plp_snprintf( list+len, sizeof(list)-len,
					" %s'%s'", key, value );
			plp_snprintf( list2+len2, sizeof(list2)-len2,
					" %s%s", key, value );
		} else {
			plp_snprintf( list+len, sizeof(list)-len,
					" '%s'", value );
			plp_snprintf( list2+len2, sizeof(list2)-len2,
					" %s", value );
		}
		parms[argc++] = &list2[len2+1];
	}
	parms[argc] = 0;
}

void doaccnt(int start)
{
	int fd;
	int i, err, pid;
	int status;
	char pid_str[32];
	char totalpages[32];
	char pages[32];
	char *sh;
	struct stat statb;

	sh = Accounting_script;
	if(debug >= 2) {
		setstatus("Accounting script '%s', file '%s', fd %d",
			Accounting_script, accntfile, Accounting_fd );
	}

	/* safe use of sprintf */
	i = getpid();
	sprintf( pid_str, "%d", i );

	/* we first set up the output line and arguments */
	sprintf( pages, "%d", npages );

	if( start ){
		strcpy( list, "start " );
	} else {
		strcpy( list, "end " );
	}
	argc = 0;
	parms[argc++] = sh;
	if( !start ){
		sprintf( totalpages, "%d", npages-initialpagecount );
		inv( "-b", totalpages );
	}
	inv( "-q", pid_str );
	inv( "-k", controlfile );
	inv( "-n", login );
	inv( "-h", host );
	inv( "-P", printer );
	inv( "-p", pages );
	inv( "-F", format );
	inv( "-R", accntname );
	inv( "-t", Time_str() );
	
	/* this is probably the best way to do the output */
	fd = Accounting_fd;
	if(fd > 0 ||
		(accntfile && (fd = open(accntfile, O_WRONLY|O_APPEND )) >= 0 )) {
		i = strlen( list );
		list[i] = '\n';
		writecn(fd,list,i+1);
		if( fd != Accounting_fd ) (void)close(fd);
		list[i] = 0;
	}
	if( sh && *sh ){
		if( stat( sh, &statb ) < 0 ){
			if (debug >= 3 ) {
				logerr("Accounting script '%s' cannot stat- %s",
					sh, Errormsg(errno) );
			}
			sh = 0;
		} else if( ! ( (statb.st_mode & 0001)
			|| ((statb.st_mode & 0010 ) && (statb.st_gid == getegid() ))
			|| ((statb.st_mode & 0100 ) && (statb.st_uid == geteuid() )) ) ){
			if (debug >= 3) {
				logerr("Accounting script '%s' has bad exec perms or ownership",
				sh );
			}
			sh = 0;
		}
		if( sh == 0 ) return;
		inv( 0, accntfile );
		if (debug >= 4) {
			setstatus("accounting '%s %s'", parms[0], list );
		}
		/* fix up parm list */
		for( i = 1; i < argc; ++i ){
			parms[i][-1] = 0;
		}
		parms[argc] = 0;
		Statuspid = fork();
		if( Statuspid == -1 ) {
			errorcode = FILTABORT;
			if (debug >= 1) {
				logerr("Cannot fork to update accounting");
			}
		} else if( Statuspid == 0 ){
			/* child - Exec the script to update pages */
			dup2(2,1);
			execve(sh,parms,Envp_p);
			errorcode = FILTABORT;
			logerr_die("Cannot exec %s to update pages field",sh);
		} else {
			/* father - Wait for the update
			 * Child exits with 0 for Ok, 2 if signal
			 * terminated and 1 otherwise.
			 */
			do{
				status = 0;
				pid = waitpid( Statuspid, &status, 0 );
				err = errno;
				if (debug >= 4) {
					setstatus("doaccnt: pid  %d, status 0x%x", pid, status );
				}
			} while( pid != Statuspid && err != ECHILD );
			Statuspid = 0;
			if (debug >= 1) {
				setstatus("Accounting process exited, status 0x%x",
					status);
			}
			if( status ){
				errorcode = FILTABORT;
				fatal("Accounting process died, status 0x%x", status);
			}
		}
	}
}
