/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 1993-2002 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

#ifndef _RMRETVAL_H_
#define _RMRETVAL_H_

#include "nvtypes.h"

/*
 * ---------------------------------------------------------------------------
 *
 * Error codes.
 *
 * ---------------------------------------------------------------------------
 */

/* External codes. */

#define NV_ERROR_1                      0x0100
#define NV_TYPE_CONFLICT                (0x01|NV_ERROR_1)
#define NV_OUT_OF_RANGE                 (0x02|NV_ERROR_1)
#define NV_NO_CONNECTION                (0x03|NV_ERROR_1)
#define NV_NO_SUCH_OBJECT               (0x04|NV_ERROR_1)
#define NV_NAME_IN_USE                  (0x05|NV_ERROR_1)
#define NV_OUT_OF_RESOURCES             (0x06|NV_ERROR_1)
#define NV_TRANSLATION_VIOLATION        (0x07|NV_ERROR_1)
#define NV_PROTECTION_VIOLATION         (0x08|NV_ERROR_1)
#define NV_BUFFER_BUSY                  (0x09|NV_ERROR_1)
#define NV_ILLEGAL_ACCESS               (0x0A|NV_ERROR_1)
#define NV_BAD_COLORMAP_FORMAT          (0x0B|NV_ERROR_1)
#define NV_BAD_COLOR_FORMAT             (0x0C|NV_ERROR_1)
#define NV_BAD_MONOCHROME_FORMAT        (0x0D|NV_ERROR_1)
#define NV_BAD_PATTERN_SHAPE            (0x0E|NV_ERROR_1)
#define NV_BAD_SUBDIVIDE                (0x0F|NV_ERROR_1)
#define NV_NO_CURRENT_POINT             (0x10|NV_ERROR_1)
#define NV_NO_DMA_TRANSLATION           (0x12|NV_ERROR_1)
#define NV_INCOMPLETE_METHOD            (0x13|NV_ERROR_1)
#define NV_RESERVED_ADDRESS             (0x14|NV_ERROR_1)
#define NV_UNIMPLEMENTED_PATCH          (0x15|NV_ERROR_1)
#define NV_OS_NAME_ERROR                (0x16|NV_ERROR_1)
#define NV_INCOMPLETE_PATCH             (0x17|NV_ERROR_1)
#define NV_BUFFERGAP_ERROR              (0x18|NV_ERROR_1)
#define NV_FIFO_OVERFLOW                (0x19|NV_ERROR_1)

/* Internal codes. */

typedef U032 RM_STATUS;

#define NUM_RM_ERRORS                   22
#define RM_OK                           0x00000000
#define RM_ERROR                        0xFFFFFFFF

#define RM_WARN_NULL_OBJECT             (0x10000000|RM_OK)
#define RM_WARN_GRAPHICS_DISABLED       (0x30000000|RM_OK)
#define RM_ERR_NO_FREE_MEM              (0x01000000|NV_OUT_OF_RESOURCES)
#define RM_ERR_MEM_NOT_FREED            (0x01010000|NV_OUT_OF_RESOURCES)
#define RM_ERR_PAGE_TABLE_NOT_AVAIL     (0x01020000|NV_OUT_OF_RESOURCES)
#define RM_ERR_NO_FREE_FIFOS            (0x02000000|NV_OUT_OF_RESOURCES)
#define RM_ERR_CANT_CREATE_CLASS_OBJS   (0x02010000|NV_OUT_OF_RESOURCES)
#define RM_ERR_BAD_OBJECT               (0x03000000|NV_NO_SUCH_OBJECT)
#define RM_ERR_INSERT_DUPLICATE_NAME    (0x03010000|NV_NAME_IN_USE)
#define RM_ERR_OBJECT_NOT_FOUND         (0x03020000|NV_NO_SUCH_OBJECT)
#define RM_ERR_OTHER_DEVICE_FOUND       (0x03040000|NV_NO_SUCH_OBJECT)
#define RM_ERR_CREATE_BAD_CLASS         (0x04000000|NV_NO_SUCH_OBJECT)
#define RM_ERR_DELETE_BAD_CLASS         (0x04010000|NV_NO_SUCH_OBJECT)
#define RM_ERR_FIFO_RUNOUT_OVERFLOW     (0x05000000|NV_FIFO_OVERFLOW)
#define RM_ERR_FIFO_BAD_ACCESS          (0x05010000|NV_RESERVED_ADDRESS)
#define RM_ERR_FIFO_OVERFLOW            (0x05020000|NV_FIFO_OVERFLOW)
#define RM_ERR_METHOD_ORDER             (0x06000000|NV_INCOMPLETE_METHOD)
#define RM_ERR_METHOD_COUNT             (0x06010000|NV_INCOMPLETE_METHOD)
#define RM_ERR_ILLEGAL_OBJECT           (0x06020000|NV_TYPE_CONFLICT)
#define RM_ERR_DMA_IN_USE               (0x07000000|NV_BUFFER_BUSY)
#define RM_ERR_BAD_DMA_SPECIFIER        (0x07010000|NV_TRANSLATION_VIOLATION)
#define RM_ERR_INVALID_XLATE            (0x07020000|NV_TRANSLATION_VIOLATION)
#define RM_ERR_INVALID_START_LENGTH     (0x07030000|NV_PROTECTION_VIOLATION)
#define RM_ERR_DMA_MEM_NOT_LOCKED       (0x07040000|NV_OUT_OF_RESOURCES)
#define RM_ERR_DMA_MEM_NOT_UNLOCKED     (0x07050000|NV_OUT_OF_RESOURCES)
#define RM_ERR_NOTIFY_IN_USE            (0x07060000|NV_BUFFER_BUSY)
#define RM_ERR_ILLEGAL_ADDRESS          (0x08000000|NV_ILLEGAL_ACCESS)
#define RM_ERR_BAD_ADDRESS              (0x08010000|NV_PROTECTION_VIOLATION)
#define RM_ERR_INVALID_COLOR_FORMAT     (0x09000000|NV_BAD_COLOR_FORMAT)
#define RM_ERR_INVALID_MONO_FORMAT      (0x09010000|NV_BAD_MONOCHROME_FORMAT)
#define RM_ERR_OBJECT_TYPE_MISMATCH     (0x0A000000|NV_TYPE_CONFLICT)
#define RM_ERR_INCOMPLETE_PATCH         (0x0C000000|NV_INCOMPLETE_PATCH)
#define RM_ERR_INVALID_PATCH            (0x0C010000|NV_UNIMPLEMENTED_PATCH)
#define RM_ERR_PATCH_TOO_COMPLEX        (0x0C020000|NV_UNIMPLEMENTED_PATCH)
#define RM_ERR_MAX_PATCH_FANOUT         (0x0C030000|NV_UNIMPLEMENTED_PATCH)
#define RM_ERR_DEVICE_DISCONNECTED      (0x0C040000|NV_NO_CONNECTION)
#define RM_ERR_BUFFER_GAP               (0x0D000000|NV_BUFFER_GAP)
#define RM_ERR_INVALID_OS_NAME          (0x0E000000|NV_OS_NAME_ERROR)
#define RM_ERR_ILLEGAL_ACTION           (0x0E010000|NV_OS_NAME_ERROR)

/* The DMA direction specified for the DMA object is not allowed in
   the specified address space. */

#define RM_ERR_ILLEGAL_DIRECTION        (0x0E020000|NV_OS_NAME_ERROR)
#define RM_ERR_OUT_OF_TIMER_CALLBACKS   (0x0F000000|NV_OUT_OF_RESOURCES)

/* Errors returned from the arch calls. */

#define NV_ERROR_2                      0x0200
#define RM_ERR_OPERATING_SYSTEM         (0x00000001|NV_ERROR_2)
#define RM_ERR_BAD_OBJECT_PARENT        (0x00000002|NV_ERROR_2)
#define RM_ERR_BAD_OBJECT_HANDLE        (0x00000003|NV_ERROR_2)
#define RM_ERR_OBJECT_IN_USE            (0x00000004|NV_ERROR_2)
#define RM_ERR_OBJECT_HAS_CHILDERN      (0x00000005|NV_ERROR_2)
#define RM_ERR_BAD_CLASS                (0x00000006|NV_ERROR_2)
#define RM_ERR_INSUFFICIENT_RESOURCES   (0x00000007|NV_ERROR_2)
#define RM_ERR_BAD_FLAGS                (0x00000008|NV_ERROR_2)
#define RM_ERR_BAD_BASE                 (0x00000009|NV_ERROR_2)
#define RM_ERR_BAD_LIMIT                (0x0000000A|NV_ERROR_2)
#define RM_ERR_PROTECTION_FAULT         (0x0000000B|NV_ERROR_2)
#define RM_ERR_MULTIPLE_MEMORY_TYPES    (0x0000000C|NV_ERROR_2)
#define RM_ERR_BAD_OBJECT_ERROR         (0x0000000D|NV_ERROR_2)
#define RM_ERR_BAD_OBJECT_BUFFER        (0x0000000E|NV_ERROR_2)
#define RM_ERR_BAD_OFFSET               (0x0000000F|NV_ERROR_2)
#define RM_ERR_BAD_CLIENT               (0x00000010|NV_ERROR_2)

/* Errors returned from HAL calls. */

#define NV_ERROR_3                      (0x0400)
#define RM_ERR_VERSION_MISMATCH         (0x00000001|NV_ERROR_3)
#define RM_ERR_BAD_ARGUMENT             (0x00000002|NV_ERROR_3)
#define RM_ERR_INVALID_STATE            (0x00000003|NV_ERROR_3)
#define RM_ERR_STATE_IN_USE             (0x00000004|NV_ERROR_3)

#endif /* _RMRETVAL_H_ */
