/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 1999-2001 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */


/*
 * Os interface definitions needed by os-interface.c
 */

#ifndef _OS_INTERFACE_H_
#define _OS_INTERFACE_H_

/******************* Operating System Interface Routines *******************\
*                                                                           *
* Module: os-interface.h                                                    *
*       Included by os.h                                                    *
*       Operating system wrapper functions used to abstract the OS.         *
*                                                                           *
\***************************************************************************/

/*
 * Define away Microsoft compiler extensions when possible
 */

#define __stdcall
#define far
#define PASCAL

/*
 * misc types used within resman
 */

typedef void *        HANDLE;
typedef void *        FLATPTR;
typedef unsigned long DWORD;

typedef          char      CHAR;
typedef          int       INT;
typedef          int       SHORT;
typedef          char     *PCHAR;
typedef          int      *PSHORT;
typedef          void     *PVOID;
typedef          char far *LPCHAR;
typedef          char far *LPSTR;
typedef          int  far *LPSHORT;
typedef unsigned char      UCHAR;
typedef unsigned int       USHORT;
typedef unsigned long      ULONG;
typedef unsigned char     *PUCHAR;
typedef unsigned int      *PUSHORT;
typedef unsigned long     *PULONG;
typedef unsigned char far *LPUCHAR;
typedef unsigned int  far *LPUSHORT;
typedef unsigned long far *LPULONG;

/*
 * ---------------------------------------------------------------------------
 *
 * Function prototypes for OS interface.
 *
 * ---------------------------------------------------------------------------
 */

U032        os_get_page_size            (VOID);
ULONG       os_get_page_mask            (VOID);
RM_STATUS   os_alloc_mem                (VOID **, U032);
VOID        os_free_mem                 (VOID *);
RM_STATUS   os_alloc_contig_pages       (VOID **, U032);
VOID        os_free_contig_pages        (VOID *, U032);
RM_STATUS   os_get_current_time         (U032 *, U032 *);
RM_STATUS   os_delay                    (U032);
RM_STATUS   os_delay_us                 (U032);
U032        os_get_cpu_frequency        (VOID);
RM_STATUS   os_get_current_process      (U032 *);
RM_STATUS   os_kill_process             (U032, U032);
U008*       os_string_copy              (U008 *, const U008 *);
RM_STATUS   os_strncpy_from_user        (U008 *, const U008 *, U032);
S032        os_string_compare           (const U008 *, const U008 *);
U032        os_string_length            (const U008 *);
U008*       os_mem_copy                 (U008 *, const U008 *, U032);
RM_STATUS   os_memcpy_from_user         (VOID *, const VOID *, U032);
RM_STATUS   os_memcpy_to_user           (void *, const VOID *, U032);
VOID*       os_mem_set                  (VOID *, U008, U032);
S032        os_mem_cmp                  (const U008 *, const U008 *, U032);
VOID*       os_pci_init_handle          (U008, U008, U008, U016 *, U016 *);
U008        os_pci_read_byte            (VOID *, U008);
U016        os_pci_read_word            (VOID *, U008);
U032        os_pci_read_dword           (VOID *, U008);
VOID        os_pci_write_byte           (VOID *, U008, U008);
VOID        os_pci_write_word           (VOID *, U008, U016);
VOID        os_pci_write_dword          (VOID *, U008, U032);
VOID*       os_map_kernel_space         (U032, U032, U032);
VOID        os_unmap_kernel_space       (VOID *, U032);
VOID*       os_map_user_space           (VOID *, VOID **, U032, U032);
VOID        os_unmap_user_space         (VOID *, VOID *);
VOID*       os_map_io_space             (U032, U032, VOID **, U032, U032);
VOID        os_unmap_io_space           (VOID *, U032, VOID *, U032);
RM_STATUS   os_flush_cpu_cache          (VOID);
RM_STATUS   os_set_mem_range            (U032, U032, U032);
RM_STATUS   os_unset_mem_range          (U032, U032);
BOOL        os_pci_device_present       (U016, U016);
U008        os_io_read_byte             (PHWINFO, U032);
U016        os_io_read_word             (PHWINFO, U032);
U032        os_io_read_dword            (PHWINFO, U032);
VOID        os_io_write_byte            (PHWINFO, U032, U008);
VOID        os_io_write_word            (PHWINFO, U032, U016);
VOID        os_io_write_dword           (PHWINFO, U032, U032);
ULONG       os_cli                      (ULONG);
ULONG       os_sti                      (ULONG);
VOID*       os_copy_in_ioctl_param      (VOID *, VOID *, U032);
VOID*       os_copy_out_ioctl_param     (VOID *, VOID *, U032);
VOID*       os_registry_lookup          (PHWINFO, U008 *, U008 *);
RM_STATUS   os_swap_barrier             (U032, VOID (*)(VOID *), VOID *);
RM_STATUS   os_init_swap_barrier        (U032);
RM_STATUS   os_remove_swap_barrier      (U032);
BOOL        os_is_administrator         (PHWINFO);
VOID        os_dbg_init                 (VOID);
VOID        os_dbg_breakpoint           (VOID);
VOID        os_dbg_set_level            (U032);
U032        os_get_cpu_count            (VOID);
RM_STATUS   os_raise_smp_barrier        (VOID);
RM_STATUS   os_clear_smp_barrier        (VOID);

RM_STATUS   osRaiseSmpBarrier           (VOID);
RM_STATUS   osClearSmpBarrier           (VOID);

/*
 * ---------------------------------------------------------------------------
 *
 * Debug macros.
 *
 * ---------------------------------------------------------------------------
 */

/* enable debugging if any OS debugging flag is set */
#undef DEBUGGING
#if defined(DEBUG) || defined(DBG)
#define DEBUGGING
#endif

#if !defined(DBG_LEVEL_INFO)
/*
 * Debug Level values
 */
#define DBG_LEVEL_INFO          0x0   /* For informational debug trace info */
#define DBG_LEVEL_SETUPINFO     0x1   /* For informational debug setup info */
#define DBG_LEVEL_USERERRORS    0x2   /* For debug info on app level errors */ 
#define DBG_LEVEL_WARNINGS      0x3   /* For RM debug warning info          */
#define DBG_LEVEL_ERRORS        0x4   /* For RM debug error info            */
#endif

#define NV_DBG_INFO       0x0
#define NV_DBG_SETUP      0x1
#define NV_DBG_USERERRORS 0x2
#define NV_DBG_WARNINGS   0x3
#define NV_DBG_ERRORS     0x4


inline void out_string(const char *str);
int nv_printf(int debuglevel, const char *printf_format, ...);


#define NV_MEMORY_TYPE_SYSTEM       0
#define NV_MEMORY_TYPE_AGP          1

#define NV_MEMORY_NONCONTIGUOUS     0
#define NV_MEMORY_CONTIGUOUS        1

#define NV_MEMORY_DEFAULT           0
#define NV_MEMORY_UNCACHED          1
#define NV_MEMORY_WRITECOMBINED     2
#define NV_MEMORY_WRITETHRU         3
#define NV_MEMORY_WRITEPROTECT      4
#define NV_MEMORY_WRITEBACK         5

/* in some cases, the os may have a different page size, but the
 * hardware (fb, regs, etc) still address and "think" in 4k
 * pages. make sure we can mask and twiddle with these addresses when
 * PAGE_SIZE isn't what we want.
 */
#define RM_PAGE_SIZE                4096
#define OS_PAGE_SIZE                (os_get_page_size())
#define OS_PAGE_MASK                (os_get_page_mask())

#define	RM_PAGES_PER_OS_PAGES       (OS_PAGE_SIZE/RM_PAGE_SIZE)
#define	RM_PAGES_TO_OS_PAGES(count) (((count) + RM_PAGES_PER_OS_PAGES - 1) \
                                       / RM_PAGES_PER_OS_PAGES)

#endif /* _OS_INTERFACE_H_ */
