 /***************************************************************************\
|*                                                                           *|
|*       Copyright 1993-1998 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NOTICE TO USER:   The source code  is copyrighted under  U.S. and     *|
|*     international laws.  Users and possessors of this source code are     *|
|*     hereby granted a nonexclusive,  royalty-free copyright license to     *|
|*     use this code in individual and commercial software.                  *|
|*                                                                           *|
|*     Any use of this source code must include,  in the user documenta-     *|
|*     tion and  internal comments to the code,  notices to the end user     *|
|*     as follows:                                                           *|
|*                                                                           *|
|*       Copyright 1993-1998 NVIDIA, Corporation.  All rights reserved.      *|
|*                                                                           *|
|*     NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY     *|
|*     OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"     *|
|*     WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPOR-     *|
|*     ATION DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,     *|
|*     INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGE-     *|
|*     MENT,  AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL     *|
|*     NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCI-     *|
|*     DENTAL, OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RE-     *|
|*     SULTING FROM LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION     *|
|*     OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF     *|
|*     OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.     *|
|*                                                                           *|
|*     U.S. Government  End  Users.   This source code  is a "commercial     *|
|*     item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),     *|
|*     consisting  of "commercial  computer  software"  and  "commercial     *|
|*     computer  software  documentation,"  as such  terms  are  used in     *|
|*     48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Govern-     *|
|*     ment only as  a commercial end item.   Consistent with  48 C.F.R.     *|
|*     12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),     *|
|*     all U.S. Government End Users  acquire the source code  with only     *|
|*     those rights set forth herein.                                        *|
|*                                                                           *|
 \***************************************************************************/


 /***************************************************************************\
|*                                                                           *|
|*                         NV Architecture Interface                         *|
|*                                                                           *|
|*  <nvtypes.h> defines common widths used to access hardware in of NVIDIA's *|
|*  Unified Media Architecture (TM).                                         *|
|*                                                                           *|
 \***************************************************************************/


#ifndef NVTYPES_INCLUDED
#define NVTYPES_INCLUDED
#ifdef __cplusplus
extern "C" {
#endif


#if defined(_H2INC) || ((defined(WIN32) || defined(_WIN32)) && !defined(_WIN32_WINNT)) /* win9x */ || defined(__DJGPP__) || defined(SIM_BUILD)
#undef NVRM_64
#else                                             /* all other platforms */
#define NVRM_64 1
#  if defined(_WIN64) || defined(NV_64_BITS)
#    define NVRM_TRUE64 1
#  endif
#endif

#if defined(NV_UNIX) || defined(MACOS) || defined(macintosh) || defined(__APPLE_CC__) || defined(vxworks) || defined(__DJGPP__) || defined (SIM_BUILD)
#define __int64 long long int
#endif

 /***************************************************************************\
|*                                 Typedefs                                  *|
 \***************************************************************************/

typedef unsigned char      NvV8;  /* "void": enumerated or multiple fields   */
typedef unsigned short     NvV16; /* "void": enumerated or multiple fields   */
typedef unsigned char      NvU8;  /* 0 to 255                                */
typedef unsigned short     NvU16; /* 0 to 65535                              */
typedef signed char        NvS8;  /* -128 to 127                             */
typedef signed short       NvS16; /* -32768 to 32767                         */
typedef float              NvF32; /* IEEE Single Precision (S1E8M23)         */
typedef double             NvF64; /* IEEE Double Precision (S1E11M52)        */

/* mainly for 64-bit linux, where long is 64 bits
 * and win9x, where int is 16 bit.
 */
#if defined(NV_UNIX) || defined(vxworks)
typedef unsigned int       NvV32; /* "void": enumerated or multiple fields   */
typedef unsigned int       NvU32; /* 0 to 4294967295                         */
typedef signed int         NvS32; /* -2147483648 to 2147483647               */
#else
typedef unsigned long      NvV32; /* "void": enumerated or multiple fields   */
typedef unsigned long      NvU32; /* 0 to 4294967295                         */
typedef signed long        NvS32; /* -2147483648 to 2147483647               */
#endif

 /***************************************************************************\
|*                                                                           *|
|*  64 bit type definitions for use in interface structures.                 *|
|*                                                                           *|
 \***************************************************************************/

#if defined(NVRM_TRUE64)

typedef unsigned __int64   NvV64; /* "void": enumerated or multiple fields   */
typedef unsigned __int64   NvU64; /* 0 to 18446744073709551615               */
typedef __int64            NvS64; /* 2^-63 to 2^63-1                         */
typedef void*              NvP64; /* 64 bit void pointer                     */

typedef NvU64 NvU64_VALUE_T;
typedef NvP64 NvP64_VALUE_T;

#define NvU64_VALUE(n)    (n)
#define NvP64_VALUE(n)    (n)
#define NvP64_SELECTOR(n) (0)

#elif defined(NVRM_64)

typedef unsigned __int64   NvV64; /* "void": enumerated or multiple fields   */
typedef unsigned __int64   NvU64; /* 0 to 18446744073709551615               */
typedef __int64            NvS64; /* 2^-63 to 2^63-1                         */
typedef unsigned __int64   NvP64; /* 64 bit void pointer                     */

typedef NvU64 NvU64_VALUE_T;
typedef NvP64 NvP64_VALUE_T;

#define NvU64_VALUE(n)    (n)
#define NvP64_VALUE(n)    (n)
#define NvP64_SELECTOR(n) (0)

#else

typedef struct {
 NvU32 low;
 NvU32 high;
}                          NvV64; /* "void": enumerated or multiple fields   */
typedef struct {
 NvU32 low;
 NvU32 high;
}                          NvU64; /* 0 to 18446744073709551615               */
typedef struct {
 NvU32 low;
 NvS32 high;
}                          NvS64; /* 2^-63 to 2^63-1                         */
typedef struct {
 NvU32 offset;
 NvU16 selector;
 NvU16 reserved;
}                          NvP64; /* 64 bit void pointer                     */

typedef NvU32 NvP64_VALUE_T;
typedef NvU32 NvU64_VALUE_T;

#define NvU64_VALUE(n)    ((n).low)
#define NvP64_VALUE(n)    ((n).offset)
#define NvP64_SELECTOR(n) ((n).selector)

#endif

 /***************************************************************************\
|*                                                                           *|
|*  Physical address definitions.                                            *|
|*                                                                           *|
 \***************************************************************************/

typedef NvU32   NvPhysAddr;

 /***************************************************************************\
|*                                                                           *|
|*  64 bit integer definitions for high precision arithmetic.                *|
|*  Ideally, NvU64/NvS64 would be a flat integer on all platforms            *|
|*  but __int64 is not recognized by 16 bit compilers.                       *|
|*                                                                           *|
 \***************************************************************************/

#if (defined(_WIN32) && !defined(_H2INC)) || defined(NVRM_64)
typedef unsigned __int64   NvUI64; /* 0 to 18446744073709551615              */
typedef __int64            NvSI64; /* 2^-63 to 2^63-1                        */
#elif defined(__GNUC__)
typedef unsigned long long int NvUI64; /* 0 to 18446744073709551615          */
typedef          long long int NvSI64; /* 2^-63 to 2^63-1                    */
#endif

/* obsolete stuff */
typedef NvV8  V008;
typedef NvV16 V016;
typedef NvV32 V032;
typedef NvV64 V064;
typedef NvU8  U008;
typedef NvU16 U016;
typedef NvU32 U032;
typedef NvU64 U064;
typedef NvS8  S008;
typedef NvS16 S016;
typedef NvS32 S032;
typedef NvS64 S064;
typedef NvP64 P064;
typedef NvF32 F032;
typedef NvF64 F064;
#if defined(MACOS) || defined(macintosh) || defined(__APPLE_CC__)
// more obsolete stuff
// need to provide these on macos9 and macosX
#if defined(__APPLE_CC__)  // gross but Apple osX already claims ULONG
#undef ULONG    // just in case
#define ULONG unsigned long
#else
typedef unsigned long  ULONG;
#endif
typedef unsigned long  DWORD;
typedef unsigned char *PUCHAR;
typedef void           VOID;
typedef void          *PVOID;
typedef void          *HANDLE;
#endif

/* polymorphic 64-bit macros */
#if defined(NVRM_TRUE64)
typedef NvP64 VOID_PTR;
typedef NvU64 NV_UINTPTR_T;
#else
typedef NvU32 VOID_PTR;
typedef NvU32 NV_UINTPTR_T;
#endif


 /***************************************************************************\
|*                               Notification                                *|
 \***************************************************************************/


/***** NvNotification Structure *****/
/*
 * NV objects return information about method completion to clients via an
 * array of notification structures in main memory.
 *
 * The client sets the status field to NV???_NOTIFICATION_STATUS_IN_PROGRESS.
 * NV fills in the NvNotification[] data structure in the following order:
 * timeStamp, otherInfo32, otherInfo16, and then status.
 */


/* memory data structures */
typedef volatile struct {
 struct {                      /*                                   0000-    */
  NvU32 nanoseconds[2];        /* nanoseconds since Jan. 1, 1970       0-   7*/
 } timeStamp;                  /*                                       -0007*/
 NvV32 info32;                 /* info returned depends on method   0008-000b*/
 NvV16 info16;                 /* info returned depends on method   000c-000d*/
 NvV16 status;                 /* user sets bit 15, NV sets status  000e-000f*/
} NvNotification;
/* status values */

#if !defined(_H2INC)

 /***************************************************************************\
|*                            NvGetReport                                    *|
 \***************************************************************************/

/***** NvGetReport Structure *****/

/*
 * NV objects, starting with Kelvin, return information such as pixel counts to
 * the user via the NV*_GET_REPORT method.
 *
 * The client fills in the "zero" field to any nonzero value and waits until it
 * becomes zero.  NV fills in the timeStamp, value, and zero fields.
 */
typedef volatile struct {
    struct {                   /*                                   0000-    */
        NvU32 nanoseconds[2];  /* nanoseconds since Jan. 1, 1970       0-   7*/
    } timeStamp;               /*                                       -0007*/
    NvU32 value;               /* info returned depends on method   0008-000b*/
    NvU32 zero;                /* always written to zero            000c-000f*/
} NvGetReport;

 /***************************************************************************\
|*                          NvGraphicsState                                  *|
 \***************************************************************************/

/***** NvGraphicsState Structure *****/
/*
 * This represents the state structure that's passed between the Celsius
 * GetState method and the RM (in nv10 and eventually the HW). The context
 * DMA passed to NV056_SET_CONTEXT_DMA_STATE should be at least this size.
 */

typedef volatile struct {
    struct _PerFragmentState {
        /* *** dword 0 */
        NvU32          pad0 : 8;
        NvU32     alphaFunc : 4;
        NvU32          pad1 : 4;
        NvU32     depthFunc : 4;
        NvU32          pad2 : 4;
        NvU32     depthMask : 1;
        NvU32          pad3 : 1;
        NvU32     alphaMask : 1;
        NvU32       redMask : 1;
        NvU32     greenMask : 1;
        NvU32      blueMask : 1;
        NvU32          pad4 : 2;
        /* *** dword 1 */
        NvU32          pad5 : 4;
        NvU32   stencilFunc : 4;
        NvU32    stencilRef : 8;
        NvU32          pad6 : 8;
        NvU32   stencilMask : 8;
        /* *** dword 2 */
        NvU32       sfailOp : 4;
        NvU32       zfailOp : 4;
        NvU32       zpassOp : 4;
        NvU32         pad7 : 20;
        /* *** dword 3 */
        NvU32 blendEquation : 3;
        NvU32          pad8 : 1;
        NvU32      srcBlend : 4;
        NvU32     destBlend : 4;
        NvU32         pad9 : 20;
    } PerFragmentState;
    struct _PerVertexState {
        NvF32           pad0[4];
        NvF32   primaryColor[4];
        NvF32 secondaryColor[3];
        NvF32          fogCoord;
        NvF32    texCoord[2][4];
        NvF32         normal[3];
        NvF32              pad1;
        NvF32      vertexWeight;
        NvU32           pad2[7];
        NvU32              pad3;
        NvU32      edgeFlag : 8;
        NvU32         pad4 : 24;
        NvU32           pad5[2];
    } PerVertexState;
    NvU32       glBeginEndState;
    struct _VertexArrayState {
        NvU32      vertexOffset;
        NvU32      vertexFormat;
        NvU32     diffuseOffset;
        NvU32     diffuseFormat;
        NvU32    specularOffset;
        NvU32    specularFormat;
        NvU32   texCoord0Offset;
        NvU32   texCoord0Format;
        NvU32   texCoord1Offset;
        NvU32   texCoord1Format;
        NvU32      normalOffset;
        NvU32      normalFormat;
        NvU32      weightOffset;
        NvU32      weightFormat;
        NvU32         fogOffset;
        NvU32         fogFormat;
    } VertexArrayState;
    struct _PrimitiveAssmState {
        NvU32    primAssm[3*16];
    } PrimitiveAssmState;
} NvGraphicsState;

#endif /* !defined(_H2INC) */

#ifdef __cplusplus
};
#endif

#endif /* NVTYPES_INCLUDED */
