/*
 * Copyright 2015 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 */

#ifndef __NV_KMS_H__
#define __NV_KMS_H__

#include "nvtypes.h"
#include <stddef.h> /* size_t */

/*
 * On Linux-x86, the kernel's function calling convention may pass
 * parameters in registers.  Force functions called to and from core
 * NVKMS to pass parameters on the stack.
 */
#if NVCPU_IS_X86
  #define NVKMS_API_CALL __attribute__((regparm(0)))
#else
  #define NVKMS_API_CALL
#endif

typedef struct nvkms_per_open nvkms_per_open_handle_t;

enum NvKmsIoctlOrigin {
    NVKMS_IOCTL_FROM_USER_SPACE,
    NVKMS_IOCTL_FROM_KERNEL_SPACE,
};

NvBool NVKMS_API_CALL nvKmsIoctl(void *pOpenVoid,
                                 NvU32 cmd,
                                 const enum NvKmsIoctlOrigin ioctlOrigin,
                                 NvU64 paramsAddress,
                                 const size_t paramSize);

void NVKMS_API_CALL nvKmsClose(void *pOpenVoid);

void* NVKMS_API_CALL nvKmsOpen(nvkms_per_open_handle_t *pOpenKernel);

void NVKMS_API_CALL nvKmsModuleLoad(void);

void NVKMS_API_CALL nvKmsModuleUnload(void);

void NVKMS_API_CALL nvKmsSuspend(NvU32 gpuId);
void NVKMS_API_CALL nvKmsResume(NvU32 gpuId);

#endif /* __NV_KMS_H__ */
