/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 2015 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

#include "nv-modeset-interface.h"

#include "nv-misc.h"
#include "os-interface.h"
#include "nvstatus.h"
#include "nv.h"
#include "nv-freebsd.h"

static int nvidia_modeset_rm_ops_alloc_stack(nvidia_stack_t **sp)
{
    NV_UMA_ZONE_ALLOC_STACK(*sp);
    return (*sp == NULL) ? ENOMEM : 0;
}

static void nvidia_modeset_rm_ops_free_stack(nvidia_stack_t *sp)
{
    NV_UMA_ZONE_FREE_STACK(sp);
}

NV_STATUS nvidia_get_rm_ops(nvidia_modeset_rm_ops_t *rm_ops)
{
    const nvidia_modeset_rm_ops_t local_rm_ops = {
        NV_VERSION_STRING,
        nvidia_modeset_rm_ops_alloc_stack,
        nvidia_modeset_rm_ops_free_stack,
        rm_kernel_rmapi_op, /* provided by nv-kernel.o */
    };

    if (strcmp(rm_ops->version_string, NV_VERSION_STRING) != 0)
    {
        rm_ops->version_string = NV_VERSION_STRING;
        return NV_ERR_GENERIC;
    }

    *rm_ops = local_rm_ops;

    return NV_OK;
}


