/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 1993-2014 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

#ifndef _RMRETVAL_H_
#define _RMRETVAL_H_

#include "nvtypes.h"
#include "nvstatus.h"

/*
 * ---------------------------------------------------------------------------
 *
 * Error codes.
 *
 * ---------------------------------------------------------------------------
 */

#define RM_STATUS NV_STATUS

#define RM_OK                           NV_OK           //STATUS_SUCCESS
#define RM_ERROR                        NV_ERR_GENERIC  //STATUS_FAILURE

/*!
 * @def         RM_STATUS_LEVEL_OK
 * @see         RM_STATUS_LEVEL
 * @brief       Success: No error or special condition
 */
#define RM_STATUS_LEVEL_OK              0

/*!
 * @def         RM_STATUS_LEVEL_WARN
 * @see         RM_STATUS_LEVEL
 * @brief       Sucess, but there is an special condition
 *
 * @details     In general, RM_STATUS_LEVEL_WARN status codes are handled the
 *              same as RM_STATUS_LEVEL_OK, but are usefil to indicate that
 *              there is a condition that may be specially handled.
 *
 *              Therefore, in most cases, client function should test for
 *              status <= RM_STATUS_LEVEL_WARN or status > RM_STATUS_LEVEL_WARN
 *              to determine success v. failure of a call.
 */
#define RM_STATUS_LEVEL_WARN            1

/*!
 * @def         RM_STATUS_LEVEL_ERR
 * @see         RM_STATUS_LEVEL
 * @brief       Unrecoverable error condition
 */
#define RM_STATUS_LEVEL_ERR             3

/*!
 * @def         RM_STATUS_LEVEL
 * @see         RM_STATUS_LEVEL_OK
 * @see         RM_STATUS_LEVEL_WARN
 * @see         RM_STATUS_LEVEL_ERR
 * @brief       Level of the status code
 *
 * @warning     IMPORTANT: When comparing RM_STATUS_LEVEL(_S) against one of
 *              these constants, it is important to use '<=' or '>' (rather
 *              than '<' or '>=').
 *
 *              For example. do:
 *                  if (RM_STATUS_LEVEL(status) <= RM_STATUS_LEVEL_WARN)
 *              rather than:
 *                  if (RM_STATUS_LEVEL(status) < RM_STATUS_LEVEL_ERR)
 *
 *              By being consistent in this manner, it is easier to systematically
 *              add additional level constants.  New levels are likely to lower
 *              (rather than raise) the severity of _ERR codes.  For example,
 *              if we were to add RM_STATUS_LEVEL_RETRY to indicate hardware
 *              failures that may be recoverable (e.g. RM_ERR_TIMEOUT_RETRY
 *              or RM_ERR_BUSY_RETRY), it would be less severe than
 *              RM_STATUS_LEVEL_ERR the level to which these status codes now
 *              belong.  Using '<=' and '>' ensures your code is not broken in
 *              cases like this.
 */
#define RM_STATUS_LEVEL(_S)                                             \
    ((_S) == RM_OK?                             RM_STATUS_LEVEL_OK:     \
    ((_S) != RM_ERROR && (_S) & 0x00010000?     RM_STATUS_LEVEL_WARN:   \
                                                RM_STATUS_LEVEL_ERR))

/*!
 * @def         RM_STATUS_LEVEL
 * @see         RM_STATUS_LEVEL_OK
 * @see         RM_STATUS_LEVEL_WARN
 * @see         RM_STATUS_LEVEL_ERR
 * @brief       Character representing status code level
 */
#define RM_STATUS_LEVEL_CHAR(_S)                        \
    ((_S) == RM_OK?                             '0':    \
    ((_S) != RM_ERROR && (_S) & 0x00010000?     'W':    \
                                                'E'))


#define RM_ERR_DMA_IN_USE               NV_ERR_DMA_IN_USE
#define RM_ERR_DMA_MEM_NOT_LOCKED       NV_ERR_DMA_MEM_NOT_LOCKED
#define RM_ERR_DMA_MEM_NOT_UNLOCKED     NV_ERR_DMA_MEM_NOT_UNLOCKED
#define RM_ERR_DUAL_LINK_INUSE          NV_ERR_DUAL_LINK_INUSE
#define RM_ERR_FIFO_BAD_ACCESS          NV_ERR_FIFO_BAD_ACCESS
#define RM_ERR_GPU_NOT_FULL_POWER       NV_ERR_GPU_NOT_FULL_POWER
#define RM_ERR_ILLEGAL_ACTION           NV_ERR_ILLEGAL_ACTION
#define RM_ERR_ILLEGAL_OBJECT           NV_ERR_INVALID_OBJECT
#define RM_ERR_INSERT_DUPLICATE_NAME    NV_ERR_INSERT_DUPLICATE_NAME
#define RM_ERR_INSUFFICIENT_RESOURCES   NV_ERR_INSUFFICIENT_RESOURCES
#define RM_ERR_INVALID_ADDRESS          NV_ERR_INVALID_ADDRESS
#define RM_ERR_INVALID_ARGUMENT         NV_ERR_INVALID_ARGUMENT
#define RM_ERR_INVALID_BASE             NV_ERR_INVALID_BASE
#define RM_ERR_INVALID_CHANNEL          NV_ERR_INVALID_CHANNEL
#define RM_ERR_INVALID_CLASS            NV_ERR_INVALID_CLASS
#define RM_ERR_INVALID_CLIENT           NV_ERR_INVALID_CLIENT
#define RM_ERR_INVALID_COMMAND          NV_ERR_INVALID_COMMAND
#define RM_ERR_INVALID_DATA             NV_ERR_INVALID_DATA
#define RM_ERR_INVALID_DEVICE           NV_ERR_INVALID_DEVICE
#define RM_ERR_INVALID_DMA_SPECIFIER    NV_ERR_INVALID_DMA_SPECIFIER
#define RM_ERR_INVALID_EVENT            NV_ERR_INVALID_EVENT
#define RM_ERR_INVALID_FLAGS            NV_ERR_INVALID_FLAGS
#define RM_ERR_INVALID_FUNCTION         NV_ERR_INVALID_FUNCTION
#define RM_ERR_INVALID_HEAP             NV_ERR_INVALID_HEAP
#define RM_ERR_INVALID_INDEX            NV_ERR_INVALID_INDEX
#define RM_ERR_INVALID_LIMIT            NV_ERR_INVALID_LIMIT
#define RM_ERR_INVALID_METHOD           NV_ERR_INVALID_METHOD
#define RM_ERR_INVALID_OBJECT           NV_ERR_INVALID_OBJECT
#define RM_ERR_INVALID_OBJECT_BUFFER    NV_ERR_INVALID_OBJECT_BUFFER
#define RM_ERR_INVALID_OBJECT_ERROR     NV_ERR_INVALID_OBJECT_ERROR
#define RM_ERR_INVALID_OBJECT_HANDLE    NV_ERR_INVALID_OBJECT_HANDLE
#define RM_ERR_INVALID_OBJECT_OLD       NV_ERR_INVALID_OBJECT_OLD
#define RM_ERR_INVALID_OBJECT_PARENT    NV_ERR_INVALID_OBJECT_PARENT
#define RM_ERR_INVALID_OFFSET           NV_ERR_INVALID_OFFSET
#define RM_ERR_INVALID_OWNER            NV_ERR_INVALID_OWNER
#define RM_ERR_INVALID_PARAM_STRUCT     NV_ERR_INVALID_PARAM_STRUCT
#define RM_ERR_INVALID_POINTER          NV_ERR_INVALID_POINTER
#define RM_ERR_INVALID_READ             NV_ERR_INVALID_READ
#define RM_ERR_INVALID_STATE            NV_ERR_INVALID_STATE
#define RM_ERR_INVALID_WRITE            NV_ERR_INVALID_WRITE
#define RM_ERR_INVALID_XLATE            NV_ERR_INVALID_XLATE
#define RM_ERR_IRQ_NOT_FIRING           NV_ERR_IRQ_NOT_FIRING
#define RM_ERR_MULTIPLE_MEMORY_TYPES    NV_ERR_MULTIPLE_MEMORY_TYPES
#define RM_ERR_NO_FREE_FIFOS            NV_ERR_NO_FREE_FIFOS
#define RM_ERR_NO_MEMORY                NV_ERR_NO_MEMORY
#define RM_ERR_NOT_SUPPORTED            NV_ERR_NOT_SUPPORTED
#define RM_ERR_OBJECT_NOT_FOUND         NV_ERR_OBJECT_NOT_FOUND
#define RM_ERR_OBJECT_TYPE_MISMATCH     NV_ERR_OBJECT_TYPE_MISMATCH
#define RM_ERR_OPERATING_SYSTEM         NV_ERR_OPERATING_SYSTEM
#define RM_ERR_OTHER_DEVICE_FOUND       NV_ERR_OTHER_DEVICE_FOUND
#define RM_ERR_CALLBACK_NOT_SCHEDULED   NV_ERR_CALLBACK_NOT_SCHEDULED
#define RM_ERR_PAGE_TABLE_NOT_AVAIL     NV_ERR_PAGE_TABLE_NOT_AVAIL
#define RM_ERR_PROTECTION_FAULT         NV_ERR_PROTECTION_FAULT
#define RM_ERR_STATE_IN_USE             NV_ERR_STATE_IN_USE
#define RM_ERR_TIMEOUT                  NV_ERR_TIMEOUT
#define RM_ERR_BUFFER_TOO_SMALL         NV_ERR_BUFFER_TOO_SMALL
#define RM_ERR_NO_SUCH_DOMAIN           NV_ERR_NO_SUCH_DOMAIN
#define RM_ERR_I2C_ERROR                NV_ERR_I2C_ERROR
#define RM_ERR_FREQ_NOT_SUPPORTED       NV_ERR_FREQ_NOT_SUPPORTED
#define RM_ERR_INVALID_REQUEST          NV_ERR_INVALID_REQUEST
#define RM_ERR_MISSING_TABLE_ENTRY      NV_ERR_MISSING_TABLE_ENTRY
#define RM_ERR_NO_INTR_PENDING          NV_ERR_NO_INTR_PENDING
#define RM_ERR_INSUFFICIENT_PERMISSIONS NV_ERR_INSUFFICIENT_PERMISSIONS
#define RM_ERR_TIMEOUT_RETRY            NV_ERR_TIMEOUT_RETRY
#define RM_ERR_NOT_READY                NV_ERR_NOT_READY
#define RM_ERR_BROKEN_FB                NV_ERR_BROKEN_FB
#define RM_ERR_GPU_IS_LOST              NV_ERR_GPU_IS_LOST
#define RM_ERR_GPU_IN_FULLCHIP_RESET    NV_ERR_GPU_IN_FULLCHIP_RESET
#define RM_ERR_INVALID_LOCK_STATE       NV_ERR_INVALID_LOCK_STATE
#define RM_ERR_INSUFFICIENT_POWER       NV_ERR_INSUFFICIENT_POWER
#define RM_ERR_REJECTED_VBIOS           NV_ERR_REJECTED_VBIOS
#define RM_ERR_MEMORY_TRAINING_FAILED   NV_ERR_MEMORY_TRAINING_FAILED
#define RM_ERR_COMPRESSION_ERROR        NV_ERR_INFLATE_COMPRESSED_DATA_FAILED
#define RM_ERR_I2C_SPEED_TOO_HIGH       NV_ERR_I2C_SPEED_TOO_HIGH
#define RM_ERR_INVALID_IRQ_LEVEL        NV_ERR_INVALID_IRQ_LEVEL
#define RM_ERR_BUSY_RETRY               NV_ERR_BUSY_RETRY
#define RM_ERR_RESET_REQUIRED           NV_ERR_RESET_REQUIRED

#define RM_ERR_INVALID_PATH             NV_ERR_INVALID_PATH
#define RM_ERR_HOT_SWITCH               NV_ERR_HOT_SWITCH
#define RM_ERR_MISMATCHED_TARGET        NV_ERR_MISMATCHED_TARGET
#define RM_ERR_OUT_OF_RANGE             NV_ERR_OUT_OF_RANGE
#define RM_ERR_NO_VALID_PATH            NV_ERR_NO_VALID_PATH
#define RM_ERR_CONSTRAINT_VIOLATION     NV_ERR_OUT_OF_RANGE
#define RM_ERR_CYCLE_DETECTED           NV_ERR_CYCLE_DETECTED
#define RM_ERR_MISMATCHED_SLAVE         NV_ERR_MISMATCHED_SLAVE

#define RM_ERR_MORE_DATA_AVAILABLE      NV_ERR_MORE_DATA_AVAILABLE
#define RM_ERR_MODULE_LOAD_FAILED       NV_ERR_MODULE_LOAD_FAILED
#define RM_ERR_OVERLAPPING_UVM_COMMIT   NV_ERR_OVERLAPPING_UVM_COMMIT
#define RM_ERR_UVM_ADDRESS_IN_USE       NV_ERR_UVM_ADDRESS_IN_USE
#define RM_ERR_GPU_DMA_NOT_INITIALIZED  NV_ERR_GPU_DMA_NOT_INITIALIZED
#define RM_ERR_ECC_ERROR                NV_ERR_ECC_ERROR
#define RM_ERR_RC_ERROR                 NV_ERR_RC_ERROR
#define RM_ERR_SIGNAL_PENDING           NV_ERR_SIGNAL_PENDING
#define RM_ERR_PID_NOT_FOUND            NV_ERR_PID_NOT_FOUND
#define RM_ERR_GPU_UUID_NOT_FOUND       NV_ERR_GPU_UUID_NOT_FOUND

#define RM_ERR_MAX_SESSION_LIMIT_REACHED    NV_ERR_MAX_SESSION_LIMIT_REACHED

// Warnings:
#define RM_WARN_NULL_OBJECT                 NV_WARN_NULL_OBJECT
#define RM_WARN_INCORRECT_PERFMON_DATA      NV_WARN_INCORRECT_PERFMON_DATA
#define RM_WARN_NOTHING_TO_DO               NV_WARN_NOTHING_TO_DO
#define RM_WARN_MORE_PROCESSING_REQUIRED    NV_WARN_MORE_PROCESSING_REQUIRED
#define RM_WARN_HOT_SWITCH                  NV_WARN_HOT_SWITCH
#define RM_WARN_MISMATCHED_TARGET           NV_WARN_MISMATCHED_TARGET
#define RM_WARN_OUT_OF_RANGE                NV_WARN_OUT_OF_RANGE
#define RM_WARN_MISMATCHED_SLAVE            NV_WARN_MISMATCHED_SLAVE

#endif /* _RMRETVAL_H_ */
