/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 2001-2002 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

#include "nv-misc.h"
#include "os-interface.h"
#include "nv.h"
#include "nv-freebsd.h"


void* os_pci_init_handle(
    NvU32 domain,
    NvU8  bus,
    NvU8  slot,
    NvU8  function,
    NvU16 *vendor,
    NvU16 *device
)
{
    device_t dev;

    /*
     * Find a PCI device based on its address, and return a unique handle
     * to be used in subsequent calls to read from or write to the config
     * space of this device.
     */

    dev = pci_find_dbsf(domain, bus, slot, function);

    if (dev != NULL) {
        if (vendor)
            *vendor = pci_get_vendor(dev);
        if (device)
            *device = pci_get_device(dev);
    }

    return (void *) dev;
}

NvU8 os_pci_read_byte(
    void *handle,
    NvU8 offset
)
{
    return pci_read_config((device_t) handle, offset, 1);
}

NvU16 os_pci_read_word(
    void *handle,
    NvU8 offset
)
{
    return pci_read_config((device_t) handle, offset, 2);
}

NvU32 os_pci_read_dword(
    void *handle,
    NvU8 offset
)
{
    return pci_read_config((device_t) handle, offset, 4);
}

void os_pci_write_byte(
    void *handle,
    NvU8 offset,
    NvU8 value
)
{
    pci_write_config((device_t) handle, offset, value, 1);
}

void os_pci_write_word(
    void *handle,
    NvU8  offset,
    NvU16 value
)
{
    pci_write_config((device_t) handle, offset, value, 2);
}

void os_pci_write_dword(
    void *handle,
    NvU8  offset,
    NvU32 value
)
{
    pci_write_config((device_t) handle, offset, value, 4);
}

BOOL os_pci_device_present(
    NvU16 vendor,
    NvU16 device
)
{
    if (pci_find_device(vendor, device))
        return TRUE;
    return FALSE;
}

