/*
 * nvidia-installer: A tool for installing NVIDIA software packages on
 * Unix and Linux systems.
 *
 * Copyright (C) 2003 NVIDIA Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the:
 *
 *      Free Software Foundation, Inc.
 *      59 Temple Place - Suite 330
 *      Boston, MA 02111-1307, USA
 */

#ifndef __NVIDIA_INSTALLER_FILES_H__
#define __NVIDIA_INSTALLER_FILES_H__

#include "nvidia-installer.h"

int remove_directory(Options *op, const char *victim);
int copy_file(Options *op, const char *srcfile,
              const char *dstfile, mode_t mode);
void select_tls_class(Options *op, Package *p); /* XXX move? */
int set_destinations(Options *op, Package *p); /* XXX move? */
int get_license_acceptance(Options *op); /* XXX move? */
int get_prefixes(Options *op); /* XXX move? */
int add_kernel_module_to_package(Options *op, Package *p);
void remove_trailing_slashes(char *s);
int mode_string_to_mode(Options *op, char *s, mode_t *mode);
char *mode_to_permission_string(mode_t mode);
int directory_exists(Options *op, const char *dir);
int confirm_path(Options *op, const char *path);
int mkdir_recursive(Options *op, const char *path, const mode_t mode);
char *get_symlink_target(Options *op, const char *filename);
int install_file(Options *op, const char *srcfile,
                 const char *dstfile, mode_t mode);
size_t get_file_size(Options *op, const char *filename);
size_t fget_file_size(Options *op, const int fd);
char *get_tmpdir(Options *op);
int nvrename(Options *op, const char *src, const char *dst);
int check_for_existing_rpms(Options *op);

#endif /* __NVIDIA_INSTALLER_FILES_H__ */
