/************************************************************************ \
|*                                                                       *|
|*                                                                       *|
|*  Copyright 2001 NVIDIA Corporation. All rights reserved               *| 
|*                                                                       *|
|*  THE INFORMATION CONTAINED HEREIN IS PROPRIETARY AND CONFIDENTIAL     *|
|*  TO NVIDIA, CORPORATION. USE, REPORDUCTION OR DISCLOSURE TO ANY       *|
|*    THIRD PARTY IS SUBJECT TO WRITTEN PRE-APPROVAL BY NVIDIA CORP.     *|
|*                                                                       *|
|*    THE INFORMATION CONTAINED HEREIN IS PROVIDED "AS IS" WITHOUT       *|
|*    EXPRESS OR IMPLIED WARRANTY OF ANY KIND, INCLUDING ALL IMPLIED     *|
|*    WARRANTIES OF MERCHANTABILITY, NONINFRINGEMENT, AND FITNESS FOR A  *|
|*    PARTICULAR PURPOSE.                                                *|
|*                                                                       *|
**************************************************************************/

#ifndef _NVNET_H_
#define _NVNET_H_

#include <linux/module.h>
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/errno.h>
#include <linux/in.h>
#include <linux/ioport.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/version.h>
#include <linux/pci.h>
#include <linux/mii.h>
#include <linux/init.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/types.h>
#include <linux/delay.h>
#include <linux/ethtool.h>
#include <linux/highmem.h>
#include <asm/io.h>
#include <asm/bitops.h>
#include <asm/uaccess.h>
#include <asm/irq.h>            /* For NR_IRQS only. */
#include <linux/spinlock.h>
#include <linux/proc_fs.h>

char *linux_hdr_version_string = "NVNET Header $Revision: #7 $";

/*
 * nVidia NVNET PCI device identifier
 */
#ifndef PCI_DEVICE_ID_NVIDIA_NVNET
#define PCI_DEVICE_ID_NVIDIA_NVNET  0x01C3
#define PCI_DEVICE_ID_NVIDIA_NVNET2 0x0066
#define PCI_DEVICE_ID_NVIDIA_NVNET3 0x00D6
#endif

//#define NVNET_DEBUG                   1

/*
 * Debug controls
 */

#define DEBUG_INIT                0x00000001
#define DEBUG_OPEN                0x00000002
#define DEBUG_TX                  0x00000004
#define DEBUG_INTR                0x00000008
#define DEBUG_RX                  0x00000010
#define DEBUG_IOCTL               0x00000020
#define DEBUG_LOCK                0x00000040
#define DEBUG_STATS               0x00000080
#define DEBUG_LINK                0x00000100
#define DEBUG_PROBE               0x00000200
#define DEBUG_ALL                 0xFFFFFFFF


#ifdef NVNET_DEBUG
static unsigned long nvnet_debug = 0 ;

#define PRINTK(level, fmt, args...) if (nvnet_debug & level) \
    printk(KERN_EMERG "nvnet: " fmt, ## args)
#define NVNET_ASSERT(A)  if (!(A)) \
    printk(KERN_EMERG "Assertion failed line %x, file %s\n", __LINE__, __FILE__)

#define PRINTK_ERROR(fmt, args...) \
    printk(KERN_EMERG "nvnet: " fmt, ## args)
#else
#define PRINTK(level, fmt, args...)
#define PRINTK_ERROR(fmt, args...) 
#define NVNET_ASSERT(A) 
#endif


/*
 * Functions prototypes
 */

static int nvnet_init(struct net_device *dev);
static int nvnet_open(struct net_device *dev);
static int nvnet_close(struct net_device *dev);
static int nvnet_ioctl(struct net_device *dev, struct ifreq *rq, int cmd);
static struct net_device_stats *nvnet_stats(struct net_device *dev);
static int nvnet_config(struct net_device *dev, struct ifmap *map);
static int nvnet_init(struct net_device *dev);
static void nvnet_interrupt(int irq, void *dev_instance, struct pt_regs *regs);
static void nvnet_multicast(struct net_device *dev);

typedef enum {fail, pass} result; /* Boolean pass/fail results */
typedef enum {false, true} bool;  /* Boolean true/false results */
typedef enum {d0, d3} pstate;     /* Current power state */

/*
 * Rx allocation information
 */
struct nvnet_rx_info {

    struct sk_buff *skb;
    dma_addr_t dma;
    u32 uiLength;
    u32 reserved;
};

/*
 * Maximum Tx ring entries
 */
#define MIN_TX_RING_ENTRIES        32
#define DEFAULT_TX_RING_ENTRIES    64
#define MAX_TX_RING_ENTRIES        128

/*
 * nvnet tx_info ring entry
 */
typedef struct _nvnet_tx_info_os 
{
    //Don't add anything above this structure
    TX_INFO_ADAP TxInfoAdap;
    struct _tx_info_os *Next;
    PVOID pvID;
    PVOID pCoalesceBuffer;
    unsigned long status;
    unsigned long entries;
    dma_addr_t dma_addr[MAX_SKB_FRAGS + 1];
    unsigned long len[MAX_SKB_FRAGS + 1];

} nvnet_tx_info_os_t;
 
/* Custom device specific data goes here */
struct nvnet_private {

    struct net_device *next;        /* Next nvnet ethernet interface */
    struct pci_dev *pdev;           /* Point to PCI config structure */
    ADAPTER_API *hwapi;             /* Hardware interface routines */
    OS_API linuxapi;                /* Interface to linux os */
    ULONG hpna;             /* Non-zero if it is HPNA */
    char *regs;                     /* Pointer to memory */
    ULONG phyaddr;          /* Address of Phy */
    int initacpi;                   /* power state h/w was in when init */  
    int linkup;                     /* Link state */
    int  linkspeed;                 /* Link speed */
    bool fullduplex;                /* Duplex mode */
    bool phyiso;                    /* Isolation status */
    bool promisc;                   /* Promiscuous status */
    pstate power;
    spinlock_t lock;
    spinlock_t phylock;             /* phy lock */
    struct net_device_stats stats;

    nvnet_tx_info_os_t *tx_ring;
    unsigned long tx_ring_index;
    unsigned long tx_ring_entries;
    unsigned long tx_ring_count;
    unsigned long tx_ring_size;
    dma_addr_t tx_ring_dma;
    unsigned long tx_ring_full;
    unsigned char original_mac_addr[6]; /* Save mac address: must be reversed from value loaded by BIOS into reg */
};

/*
 * Function prototypes
 */
static int __devinit 
nvnet_probe(struct pci_dev *pdev, const struct pci_device_id *entry);
int nvnet_resume(struct pci_dev *pcidev);
int nvnet_suspend(struct pci_dev *pcidev, u32 state);
static void __devexit nvnet_remove(struct pci_dev *pdev);
#if 0
static void nvnet_watchdog(struct net_device *dev);
#endif

static int linuxallocex(void *ctx, MEMORY_BLOCKEX *mem);
static int linuxfreeex(void *ctx, MEMORY_BLOCKEX *mem) ;

extern int ADAPTER_ReadPhy  (PVOID pContext, ULONG ulPhyAddr, ULONG ulReg, ULONG *pulVal);
extern int ADAPTER_WritePhy (PVOID pContext, ULONG ulPhyAddr, ULONG ulReg, ULONG ulVal);
#endif

