/**********************************************************************
*
*  nvwavout.h
*
*  Descripion  - Header file used for pcm out structures
*
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _NVWAVOUT_H_
#define _NVWAVOUT_H_

#include "chaninfo.h"

enum {
    PO_BDBAR =   0x10,     /* Buffer Descriptor list Base Address */
    PO_CIV   =   0x14,     /* Current Index Value */
    PO_LVI   =   0x15,     /* Last Valid Index */
    PO_SR    =   0x16,     /* Status Register */
    PO_PICB  =   0x18,     /* Position In Current Buffer */
    PO_PIV   =   0x1a,     /* Prefetched Index Value */
    PO_CR    =   0x1b      /* Control Register */
};

unsigned int Nvaudio_set_dac_rate(struct Nvaudio_state * , unsigned int rate);
unsigned Nvaudio_get_dma_addr(struct Nvaudio_state *);
void __stop_dac(struct Nvaudio_state *);
void stop_dac(struct Nvaudio_state *);
void __start_dac(struct Nvaudio_state *);
void start_dac(struct Nvaudio_state *);
void __Nvaudio_update_lvi(struct Nvaudio_state *);
void Nvaudio_update_lvi(struct Nvaudio_state *);
void Nvaudio_update_ptr(struct Nvaudio_state *state);
int  Nvaudio_get_free_write_space(struct Nvaudio_state *state);
int  drain_dac(struct Nvaudio_state *state, int signals_allowed);
void Nvaudio_channel_pcminterrupt(struct Nvaudio_card *card);
u32  Nvaudio_wavoutwrite(struct Nvaudio_card *card,const char* buffer,void * pDest, int cnt);
#endif /* _NVWAVOUT_H_ */

