/**********************************************************************
*
*  nvrec.h
*
*  Descripion  - Header file to support the recording channel for nvaudio
*  Copyright (c) 2002-2003 NVIDIA Corporation
*
***********************************************************************
*/
#ifndef _NVREC_H_
#define _NVREC_H_

#include "chaninfo.h"

enum {
    PI_BDBAR =   0x0,     /* Buffer Descriptor list Base Address */
    PI_CIV   =   0x4,     /* Current Index Value */
    PI_LVI   =   0x5,     /* Last Valid Index */
    PI_SR    =   0x6,     /* Status Register */
    PI_PICB  =   0x8,     /* Position In Current Buffer */
    PI_PIV   =   0xa,     /* Prefetched Index Value */
    PI_CR    =   0xb      /* Control Register */
};

unsigned int Nvaudio_set_adc_rate(struct Nvaudio_state * state, unsigned int rate);
unsigned Nvaudio_get_recdma_addr(struct Nvaudio_state *state);
void __stop_adc(struct Nvaudio_state *state);
void stop_adc(struct Nvaudio_state *state);
void __start_adc(struct Nvaudio_state *state);
void start_adc(struct Nvaudio_state *state);
void __Nvaudio_update_reclvi(struct Nvaudio_state *state);
void Nvaudio_update_reclvi(struct Nvaudio_state *state);
void Nvaudio_update_recptr(struct Nvaudio_state *state);
int  Nvaudio_get_available_read_data(struct Nvaudio_state *state);
void Nvaudio_channel_recinterrupt(struct Nvaudio_card *card);
#endif /* _NVREC_H_ */



