#!/bin/bash

case "$1" in
    remap_page_range)
        shift
        #
        # Determine the number of arguments expected by remap_page_range.
        #
        echo "#include <linux/mm.h>
        int do_test_remap_page_range(void) {
           pgprot_t pgprot;
           remap_page_range(NULL, 0L, 0L, 0L, pgprot);
        }" > conftest.c

        gcc -c conftest.c -o conftest.5.o $* -D__KERNEL__ > /dev/null 2>&1

        echo "#include <linux/mm.h>
        int do_test_remap_page_range(void) {
           pgprot_t pgprot;
           remap_page_range(0L, 0L, 0L, pgprot);
        }" > conftest.c

        gcc -c conftest.c -o conftest.4.o $* -D__KERNEL__ > /dev/null 2>&1

        if   test -f conftest.4.o; then
          echo "4"
          rm -f conftest.{c,4.o}
        elif test -f conftest.5.o; then
          echo "5"
          rm -f conftest.{c,5.o}
        else
          #
          # We couldn't determine the number of arguments expected by the
          # remap_page_range function.
          #
          rm -f conftest.{c,*.o}
          exit 1
        fi
    ;;
esac

