#!/bin/bash

case "$1" in
    remap_page_range)
        shift
        #
        # Determine the number of arguments expected by remap_page_range.
        #
        echo "#include <linux/mm.h>
        int do_test_remap_page_range(void) {
           pgprot_t pgprot;
           remap_page_range(NULL, 0L, 0L, 0L, pgprot);
        }" > conftest.c

        RPR_TEST_5=$(gcc -c conftest.c -o /dev/null $* -D__KERNEL__ 2>&1)

        echo "#include <linux/mm.h>
        int do_test_remap_page_range(void) {
           pgprot_t pgprot;
           remap_page_range(0L, 0L, 0L, pgprot);
        }" > conftest.c

        RPR_TEST_4=$(gcc -c conftest.c -o /dev/null $* -D__KERNEL__ 2>&1)

        if   test -z "$RPR_TEST_4"; then
          echo "4"
        elif test -z "$RPR_TEST_5"; then
          echo "5"
        else
          echo "                                                           "
          echo "Warning! conftest.sh was unable to determine the number of "
          echo "arguments expected by remap_page_range: assuming 4.        "
          echo "                                                           "
          echo "4"
        fi
    ;;
esac
