/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 2000-2001 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */



/*
 * Registry variables.
 *
 * These are defined here and used throughout resman.
 * They must be set by when loading the module using insmod.
 *
 * Registry names within linux look like: NVreg_NAME.
 * The 'NAME' portion is the leaf windows registry name with spaces
 * converted to '_'.  So 'Display Type' becomes 'Display_Type'
 *
 * TODO:
 *
 *    persistence
 *        This could be added by saving them outside resman using an ioctl
 *        and then playing them back at startup.
 *
 *    device dependence
 *        currently just one global namespace
 *        This could be easily added as NVreg_01_foofoo to mean symbol foofoo
 *        on the 2nd card in system.
 *
 */

#ifndef __KERNEL__
#  define __KERNEL__
#endif
#ifndef MODULE
#  define MODULE
#endif

#define __NO_VERSION__
#define EXPORT_SYMTAB
#include <linux/module.h>

#define RM_HEADERS_MINIMAL      // we just need top half of nvrm.h, not the entire
#include <nvrm.h>

/*
 * The 2nd argument to MODULE_PARM is used to verify parameters given to the module.
 * It should be a string in the following format:
 *   	[min[-max]]{b,h,i,l,s}
 * The MIN and MAX specifiers delimit the length of the array.  If MAX
 * is omitted, it defaults to MIN; if both are omitted, the default is 1.
 * The final character is a type specifier:
 *      b	byte
 *	h	short
 *	i	int
 *	l	long
 *	s	string
 *
 * Note: much of resman considers the *existence* of a flag to be sufficient.
 *       Ie: value is ignored.
 */

U032 NVreg_resman_debuglevel = ~0;
MODULE_PARM(NVreg_resman_debuglevel, "i");

#if 0
/* We normally detect memory type on TNT cards by scanning the embedded bios.
 * Unfortunately, we've seen some cases where a TNT card has been flashed with
 * the wrong bios. For example, an SDRAM-based TNT has been flashed with an SGRAM
 * bios, and therefore claims to be an SGRAM-based TNT. We've therefore provided
 * an override here. Ifdef'ing in these variables will override the card's bios.
 * Make sure to set the value to the correct type of memory.
 * Note that we can only do so much here. There are border cases where even this
 * fails. For example, if 2 TNT cards are in the same system, one SGRAM, one SDRAM.
 */
/* SDRAM = 1, SGRAM = 2 */
U032 NVreg_VideoMemoryTypeOverride = 1;
MODULE_PARM(NVreg_VideoMemoryTypeOverride, "i");
#endif

/*
 * we've had problems with some Via chipsets in 4x mode, so we force them back
 * down to 2x mode. If you'd like to experiment with retaining 4x mode,
 * try setting this value to '1.' If that hangs the system, you're stuck with
 * 2x mode, there's nothing we can do about it.
 */
U032 NVreg_EnableVia4x = 0;
MODULE_PARM(NVreg_EnableVia4x, "i");

/*
 * Some ALi chipsets (ALi1541, ALi1647) are reported to cause severe system
 * stability problems with AGP enabled. To work around this, we disable AGP
 * on systems with these chipsets by default. It appears that updating the
 * system BIOS and using recent versions of the kernel AGP Gart driver can
 * make such systems much more stable. If you own a system with one of the
 * aforementioned chipsets and had it working reasonably well previously,
 * or if you want to experiment with BIOS and AGPGART revisions, you can
 * re-enable AGP support by setting this option to 1.
 */
U032 NVreg_EnableALiAGP = 0;
MODULE_PARM(NVreg_EnableALiAGP, "i");

#if 0
/* bit-wise mask of acceptable AGP rates.
 * Normally, the driver will compare speed modes of the chipset & card,
 * picking the highest common rate. This key forces a maximum limit, to limit
 * the driver to lower speeds. The driver will not attempt a speed beyond what
 * the chipset and card claim they are capable of.
 *   0x7 = 1 | 2 | 4
 */
/* Make sure you really know what you're doing before you enable this
 * override. By default, AGP drivers will enable the fastest AGP rate
 * your card and motherboard chipset are capable of. Then, in some cases,
 * our driver will force this rate down to work around bugs in both our
 * chipsets, and motherboard chipsets. Using this variable will override
 * our bug fixes. This may be desirable in some cases, but not most. This
 * is completely unsupported.
 */
U032 NVreg_ReqAGPRate = 0x7;
MODULE_PARM(NVreg_ReqAGPRate, "i");
#endif

#if 0
/* This is a cover-my-tail flag.
 * Basically, NVIDIA has work-arounds for various cards/chipsets that
 * we use to override basic AGP setup. This would be called after agpgart
 * has configured AGP, to force AGP into certain modes to workaround 
 * problems. Previously, these updates weren't called for agpgart, only
 * for our internal agp code. This is why some chipsets were far more stable
 * with our code than agpgart (BX for example). 
 * I've now added a call to this update code after agpgart gets set up. This
 * should be a very good thing. However, I haven't been able to fully test
 * this interaction. So, I'm adding this override to disable calling the update
 * code, in case of problems. Using this override will force agpgart behavior
 * back to the 0.94 behavior.
 * Like I said, a cover-my-tail flag ;)
 * 0 = don't use nvidia work-arounds
 * 1 (default) = use nvidia work-arounds
 */
U032 NVreg_UpdateKernelAGP = 1;
MODULE_PARM(NVreg_UpdateKernelAGP, "i");
#endif

/* enable/disable Side Band Addressing
 * NVreq_EnableAGPSBA = 0 (disable)
 */

U032 NVreg_EnableAGPSBA = 0;
MODULE_PARM(NVreg_EnableAGPSBA, "i");

/* enable/disable Fast Writes 
 * NVreg_EnableAGPFW = 0 (disable)
 */

U032 NVreg_EnableAGPFW = 0;
MODULE_PARM(NVreg_EnableAGPFW, "i");

/* The SoftEDIDs registry key enables dynamic generation of an
 * appropriate EDID for mobile LCD displays from data stored in the
 * video BIOS.  This is enabled by default.  If this is turned off,
 * then on mobile systems, a hardcoded EDID will be chosen from a
 * table, based on the value of the Mobile registry key.
 */

U032 NVreg_SoftEDIDs = 0x1;
MODULE_PARM(NVreg_SoftEDIDs, "i");


/* The Mobile registry key should only be needed on mobile systems if
 * SoftEDIDs is disabled (see above), in which case the mobile value
 * will be used to lookup the correct EDID for the mobile LCD.  The
 * possible values for Mobile are:
 *
 * 0xFFFFFFFF : let the kernel module auto detect the correct value
 * 0x00000001 : for Dell laptops
 * 0x00000002 : for non-Compal Toshiba laptops
 * 0x00000003 : for all other laptops
 * 0x00000004 : for Compal/Toshiba laptops
 * 0x00000005 : for Gateway laptops
 */

U032 NVreg_Mobile = 0xFFFFFFFF;
MODULE_PARM(NVreg_Mobile, "i");



U032 NVreg_FlatPanelMode = 0x0;
MODULE_PARM(NVreg_FlatPanelMode, "i");

