/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 1999-2001 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */


/*
 * Os interface definitions needed by os-interface.c
 */

#ifndef _OS_INTERFACE_H_
#define _OS_INTERFACE_H_

/******************* Operating System Interface Routines *******************\
*                                                                           *
* Module: os-interface.h                                                    *
*       Included by os.h                                                    *
*       Operating system wrapper functions used to abstract the OS.         *
*                                                                           *
\***************************************************************************/

/*
 * Define away Microsoft compiler extensions when possible
 */

#define __stdcall
#define far
#define PASCAL

/*
 * misc types used within resman
 */

typedef void *        HANDLE;
typedef void *        FLATPTR;
typedef unsigned long DWORD;

typedef          char      CHAR;
typedef          int       INT;
typedef          int       SHORT;
typedef          char     *PCHAR;
typedef          int      *PSHORT;
typedef          void     *PVOID;
typedef          char far *LPCHAR;
typedef          char far *LPSTR;
typedef          int  far *LPSHORT;
typedef unsigned char      UCHAR;
typedef unsigned int       USHORT;
typedef unsigned long      ULONG;
typedef unsigned char     *PUCHAR;
typedef unsigned int      *PUSHORT;
typedef unsigned long     *PULONG;
typedef unsigned char far *LPUCHAR;
typedef unsigned int  far *LPUSHORT;
typedef unsigned long far *LPULONG;

//---------------------------------------------------------------------------
//
//  Function prototypes for OS interface.
//
//---------------------------------------------------------------------------

RM_STATUS   osAllocMem              (void **, U032);
RM_STATUS   osFreeMem               (void *);
RM_STATUS   osGetCurrentTime        (U032 * seconds, U032 *useconds);
RM_STATUS   osDelay                 (U032);
RM_STATUS   osDelayUs               (U032);
U032        osGetCpuFrequency       (void);
RM_STATUS   osKillProcess(U032 pid, U032 signal);
char*       osStringCopy            (char *, const char *);
RM_STATUS   osStringNCopyFromUser(char *, const char *, int n);
U032        osStringLength          (const char *);
void       *osMemCopy(void *, const void *, U032);
RM_STATUS   osMemCopyFromUser(void *, const void *, U032);
RM_STATUS   osMemCopyToUser(void *, const void *, U032);
void       *osMemSet(void *, int c, U032);
int         osMemCmp(const void *buf0, const void *buf1, U032);
S032        osStringCompare         (const char *, const char *);

VOID       *osPciInitHandle(U008 bus, U008 slot, U008 function, U016 *vendor, U016 *device);
U008        osPciReadByte(VOID *handle, U008 offset);
U016        osPciReadWord(VOID *handle, U008 offset);
U032        osPciReadDword(VOID *handle, U008 offset);
VOID        osPciWriteByte(VOID *handle, U008 offset, U008 value);
VOID        osPciWriteWord(VOID *handle, U008 offset, U016 value);
VOID        osPciWriteDword(VOID *handle, U008 offset, U032 value);

/* remap IO memory to kernel space */
void *osMapKernelSpace(unsigned int start, unsigned int size_bytes, U032 mode);
void osUnmapKernelSpace(void *addr, unsigned int size_bytes);

/* remap memory to user space */
void *osMapUserSpace(void *kaddr, void **priv, unsigned int size_bytes, U032 mode);
void osUnmapUserSpace(void *uaddr, void *priv);

/* remap memory to user space */
void *osMapIOSpace(U032 start, U032 size_bytes, void **priv, U032 user, U032 mode);
void osUnmapIOSpace(void *addr, U032 size_bytes, void *priv, U032 user);

/* set physical memory range attributes (like write combining) */
RM_STATUS osSetMemRange(U032 start, U032 size_bytes, U032 mode);
RM_STATUS osUnsetMemRange(U032 start, U032 size_bytes);

// like osAllocMem, but no debugging info written into pages
// needed for NT, but only pass-through under Linux
RM_STATUS osAllocPool(void **addr, unsigned int size_bytes);
RM_STATUS osFreePool(void *addr);


void *osAllocContigPages(unsigned long num_pages);
void osFreeContigPages(void *addr); 
NvPhysAddr osGetKernPhysAddr(void *kern_virt_addr);


RM_STATUS   osReadRegistryBoolean   (PHWINFO, char*, char*);
RM_STATUS   osReadRegistryDword     (PHWINFO, char*, char*, U032*);
RM_STATUS   osWriteRegistryDword    (PHWINFO, char*, char*, U032);
RM_STATUS   osReadRegistryBinary    (PHWINFO, char*, char*, U008*, U032 *);
RM_STATUS   osWriteRegistryBinary   (PHWINFO, char*, char*, U008*, U032);


#define     osReadRegistryBinaryEmergencyTVOUT osReadRegistryBinary
#define     osWriteRegistryBinaryEmergencyTVOUT osWriteRegistryBinary

BOOL osPciDevicePresent(unsigned short vendor, unsigned short device);

RM_STATUS  osMapIOPortSpace(PHWINFO, U032, U032, U032*);

void osIoWriteByte(PHWINFO pdev, unsigned long address, unsigned char value);
void osIoWriteWord(PHWINFO pdev, unsigned long address, unsigned short value);
void osIoWriteDword(PHWINFO pdev, unsigned long address, unsigned int value);

unsigned char  osIoReadByte(PHWINFO pdev, unsigned long address);
unsigned short osIoReadWord(PHWINFO pdev, unsigned long address);
unsigned int   osIoReadDword(PHWINFO pdev, unsigned long address);

unsigned int osCli(unsigned int flags);
unsigned int osSti(unsigned int flags);

#define osDisableHardwareInterrupts(pDev)   flags = osCli(flags)
#define osEnableHardwareInterrupts(pDev)    flags = osSti(flags)


/*
 * prototypes for the sgi swap barrier extension
 */
RM_STATUS osSwapBarrier(int id, VOID (*callback)(VOID *), VOID *data);
RM_STATUS osInitSwapBarrier(int id);
RM_STATUS osRemoveSwapBarrier(int id);
	

/*
 * misc routines; defined in misc/asm.c
 */

extern unsigned long long nv_rdtsc(void);
extern unsigned int nv_rdcr4(void);
extern int nv_cpuid(int op, U032 *eax, U032 *ebx, U032 *ecx, U032 *edx);
extern int nv_rdmsr(int addr, U032 *eax, U032 *edx);
extern int nv_wrmsr(int addr, U032 eax, U032 edx);


/*
 * nv_error(), nv_message(), nv_panic() support
 */

#define NV_ERROR_ERRNO     (1<<31)     /* hi bit; use 'errno' */
#define NV_ERROR_PANIC     (1<<30)     /* err is fatal; panic */
#define NV_ERROR_MESSAGE (1<<29)     /* just msg; not error */
#define NV_ERROR_STATUS   (1<<28)     /* rtems status in error */
#define NV_ERROR_WARNING (1<<27)     /* just warning; no error */

#define NV_ERROR_MASK (  \
                            NV_ERROR_ERRNO | NV_ERROR_PANIC | \
                            NV_ERROR_MESSAGE | \
                            NV_ERROR_WARNING | \
                            NV_ERROR_STATUS) /* all */


int  nv_error(int error_code, const char *printf_format, ...);
void nv_panic(const char *printf_format, ...) __attribute__ ((noreturn));
void nv_abort(const char *printf_format, ...) __attribute__ ((noreturn));
void nv_message(const char *printf_format, ...);
void nv_warning(const char *printf_format, ...);
void nv_error_new_failed(void);
int nv_printf(const char *printf_format, ...);
int nv_debug(int level, const char *printf_fmt, ...);


//---------------------------------------------------------------------------
//
//  Debug macros.
//
//---------------------------------------------------------------------------

// enable debugging if any OS debugging flag is set
#undef DEBUGGING
#if defined(DEBUG) || defined(DBG)
#define DEBUGGING
#endif

// prototypes
void    osDbgInit(void);

#if !defined(DBG_LEVEL_INFO)
//
// Debug Level values
//
#define DBG_LEVEL_INFO          0x0     // For informational debug trace info  
#define DBG_LEVEL_SETUPINFO     0x1     // For informational debug setup info  
#define DBG_LEVEL_USERERRORS    0x2     // For debug info on app level errors  
#define DBG_LEVEL_WARNINGS      0x3     // For RM debug warning info
#define DBG_LEVEL_ERRORS        0x4     // For RM debug error info
#endif

#if defined(__KERNEL__)
/* AGPGART */
BOOL KernInitAGP(VOID **ap_phys_base, VOID **ap_mapped_base, U032 *apsize);
BOOL KernTeardownAGP();
RM_STATUS KernAllocAGPPages(VOID **pAddress, U032 PageCount, VOID **pPriv_data);
RM_STATUS KernMapAGPPages(void *pvma, VOID *pPriv_data);
RM_STATUS KernMapAGPNopage(VOID *address, VOID *pvma, VOID *pPriv_data, VOID **ppage);
RM_STATUS KernFreeAGPPages(VOID **pAddress, VOID *priv_data);
#endif

#define NV_MEMORY_TYPE_SYSTEM       0
#define NV_MEMORY_TYPE_AGP          1

#define NV_MEMORY_NONCONTIGUOUS     0
#define NV_MEMORY_CONTIGUOUS        1

#define NV_MEMORY_DEFAULT           0
#define NV_MEMORY_UNCACHED          1
#define NV_MEMORY_WRITECOMBINED     2
#define NV_MEMORY_WRITETHRU         3
#define NV_MEMORY_WRITEPROTECT      4
#define NV_MEMORY_WRITEBACK         5

#endif // _OS_INTERFACE_H_
