#!/usr/bin/bash
#
# Shell script to start a CBX polling job.
# cd to the directory where this script is so it can find the Kermit 
# scripts and put the result files in the right place without being told.
# 
# Optional argument #1: CBX node name (default = morningside)
#
# Frank da Cruz, CUIT
# Fri Oct 17 14:31:20 2008
# Updated Mon Jan 26 12:55:27 2009
#
cd ${0%`basename $0`}|| exit 1		# cd to script directory
D=`pwd`
n=morningside				# default node
if [ $# -gt 0 ]; then                   # can be overridden from command line
  n=$1
fi
t=usr					# tag
c="LI CNFG_USERS"			# command to execute
b=$t-$n					# tag-node for filenames
f=$b-`echo $c | tr ' ' '_'`		# tag-node-command for filenames

a=fdc@columbia.edu			# email address for reports
# a=netops@columbia.edu

d=`date +%Y%m%d_%H:%M:%S`		# date-time for email subject
./poll $n "$c" $t			# run the script
if [ $? -ne 0 ]; then			# see if it failed
  echo "CBX script $0 failed - see $D/$b.log" | \
  Mail -s "CBX script failed" $a
  exit 1
fi

# Disposition section - what to do with the results.

cat $f.cap | Mail -s "CBX Users $d" $a	# Email the result
# Add a timestamp to the archive
( echo "[==SCRIPT: $d==]"; echo ) >> $f.cap.archive
cat $f.cap >> $f.cap.archive		# Add result to the archive
echo >> $f.cap.archive			# Since it normally ends abrubtly

exit 0
