#!/bin/bash
#
# Shell script to start a CBX polling job.
# cd to the directory where this script is so it can find the Kermit 
# scripts and put the result files in the right place without being told.
# 
# Fri Oct 17 14:37:27 2008
# Revised Mon Apr 13 17:11:14 2009 to be like other xxx.sh's.
#
cd ${0%`basename $0`} || exit 1
D=`pwd`
n=morningside				# node
t=fac					# tag
c="LI FAC ALL"				# command to execute
b=$t-$n					# tag-node for filenames
f=$b-`echo $c | tr ' ' '_'`		# tag-node-command for filenames

a=fdc@columbia.edu			# email address for reports
# a=netops@columbia.edu

d=`date +%Y%m%d_%H:%M:%S`		# current date-time for email subject
./poll $n "$c" $t			# run the script
if [ $? -ne 0 ]; then			# see if it failed
  echo "CBX script $0 failed - see $D/$b.log" | \
  Mail -s "CBX FAC script failed" $a
  exit 1
fi

cat $f.cap | Mail -s "CBX FAC report $d" $a # Email the result
exit 0
