/*
 * Decompiled with CFR 0.152.
 */
package pizza.v39;

import java.io.File;
import java.io.IOException;
import pizza.v39.GeneralFile;
import pizza.v39.ZipDir;

class ZippedFile
extends GeneralFile {
    ZipDir dir;
    String name;
    String pathname;

    ZippedFile(ZipDir zipDir, String string) {
        this.dir = zipDir;
        this.name = string;
        this.pathname = string;
        if (!string.endsWith(File.separator)) {
            this.pathname = String.valueOf(this.pathname).concat(String.valueOf(File.separator));
        }
    }

    String getPath() {
        return String.valueOf(String.valueOf(String.valueOf(this.dir.getPath()).concat(String.valueOf("("))).concat(String.valueOf(this.name))).concat(String.valueOf(")"));
    }

    boolean exists() {
        return this.dir.isDirectory() && (this.dir.index(this.name) >= 0 || this.dir.index(this.pathname) >= 0);
    }

    boolean isDirectory() {
        return this.dir.isDirectory() && this.dir.index(this.pathname) >= 0;
    }

    byte[] read() throws IOException {
        if (!this.dir.isDirectory()) {
            throw new IOException("cannot open");
        }
        int n = this.dir.index(this.name);
        if (n < 0) {
            throw new IOException("cannot open");
        }
        boolean bl = false;
        this.dir.r.seek(this.dir.offsets[n]);
        byte[] byArray = new byte[30];
        this.dir.r.readFully(byArray);
        if (ZippedFile.get4LE(byArray, 0) != 67324752) {
            throw new IOException("zip file corrupted");
        }
        if (ZippedFile.get2LE(byArray, 8) != 0) {
            throw new IOException("zip file is compressed");
        }
        byte[] byArray2 = new byte[ZippedFile.get4LE(byArray, 18)];
        this.dir.r.skipBytes(ZippedFile.get2LE(byArray, 26) + ZippedFile.get2LE(byArray, 28));
        this.dir.r.readFully(byArray2);
        return byArray2;
    }

    static String[] list(ZipDir zipDir, String string) {
        Object object;
        int n = 0;
        for (int i = 0; i < zipDir.filenames.length; ++i) {
            if (!zipDir.filenames[i].startsWith(string) || ((String)(object = zipDir.filenames[i].substring(string.length()))).indexOf(File.separatorChar) >= 0) continue;
            ++n;
        }
        object = new String[n];
        n = 0;
        for (int i = 0; i < zipDir.filenames.length; ++i) {
            String string2;
            if (!zipDir.filenames[i].startsWith(string) || (string2 = zipDir.filenames[i].substring(string.length())).indexOf(File.separatorChar) >= 0) continue;
            object[n++] = string2;
        }
        return object;
    }

    String[] list() throws IOException {
        if (!this.isDirectory()) {
            throw new IOException("not a directory");
        }
        return ZippedFile.list(this.dir, this.pathname);
    }

    GeneralFile open(String string) {
        return new ZippedFile(this.dir, String.valueOf(this.pathname).concat(String.valueOf(string)));
    }

    static int get2LE(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8);
    }

    static int get4LE(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + ((byArray[n + 1] & 0xFF) << 8) + ((byArray[n + 2] & 0xFF) << 16) + ((byArray[n + 3] & 0xFF) << 24);
    }
}

