/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.UnsupportedEncodingException;
import kaffe.util.Assert;

public abstract class ByteToCharConverter {
    private static String encodingRoot = System.getProperty("file.encoding.pkg");
    private static String encodingDefault = System.getProperty("file.encoding");
    protected byte[] buf;
    protected int blen;

    void carry(byte[] byArray, int n, int n2) {
        int n3 = this.blen + n2;
        Assert.that(this.blen == 0);
        if (this.buf == null) {
            int n4 = n2 < 128 ? 128 : n2;
            this.buf = new byte[n4];
        } else if (n3 > this.buf.length) {
            int n5;
            for (n5 = this.buf.length * 2; n5 < n3; n5 *= 2) {
            }
            byte[] byArray2 = new byte[n5];
            System.arraycopy(this.buf, 0, byArray2, 0, this.blen);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.blen, n2);
        this.blen = n3;
    }

    public abstract int convert(byte[] var1, int var2, int var3, char[] var4, int var5, int var6);

    public int flush(char[] cArray, int n, int n2) {
        if (this.blen == 0) {
            return 0;
        }
        int n3 = this.blen;
        this.blen = 0;
        return this.convert(this.buf, 0, n3, cArray, n, n2);
    }

    public static ByteToCharConverter getConverter(String string) throws UnsupportedEncodingException {
        try {
            return (ByteToCharConverter)Class.forName(String.valueOf(String.valueOf(encodingRoot).concat(String.valueOf(".ByteToChar"))).concat(String.valueOf(string))).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedEncodingException(string);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    public static ByteToCharConverter getDefault() {
        try {
            return ByteToCharConverter.getConverter(encodingDefault);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return ByteToCharConverter.getConverter("Default");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return null;
            }
        }
    }

    public abstract int getNumberOfChars(byte[] var1, int var2, int var3);
}

