/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    public static final int DEFLATED = 8;
    public static final int STORED = 0;
    private static final int ZIPVER = 10;
    private int method = 0;
    private int level = -1;
    private byte[] lh = new byte[30];
    private byte[] ch = new byte[46];
    private byte[] ce = new byte[22];
    private ZipEntry curr;
    private Vector dir;
    private OutputStream strm;
    private int dout;
    private int eout;
    private CRC32 crc;

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.strm = outputStream;
        this.curr = null;
        this.dir = new Vector();
        this.dout = 0;
        this.crc = new CRC32();
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    public void closeEntry() throws IOException {
        if (this.curr == null) {
            return;
        }
        super.finish();
        int n = this.def.getTotalIn();
        int n2 = this.def.getTotalOut();
        long l = this.crc.getValue();
        this.def.reset();
        this.crc.reset();
        if (this.curr.csize != -1L && this.curr.csize != (long)n2) {
            throw new ZipException("compress size set incorrectly");
        }
        if (this.curr.size != -1L && this.curr.size != (long)n) {
            throw new ZipException("uncompress size set incorrectly");
        }
        if (this.curr.crc != 0L && this.curr.crc != l) {
            throw new ZipException("crc set incorrectly");
        }
        this.curr.csize = n2;
        this.curr.size = n;
        this.curr.crc = l;
        this.dout = (int)((long)this.dout + this.curr.csize);
        this.curr = null;
    }

    public void finish() throws IOException {
        if (this.dir == null) {
            return;
        }
        this.closeEntry();
        Enumeration enumeration = this.dir.elements();
        int n = 0;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            this.put32(this.ch, 0, 33639248);
            this.put16(this.ch, 4, 10);
            this.put16(this.ch, 6, 10);
            this.put16(this.ch, 8, zipEntry.flag);
            this.put16(this.ch, 10, zipEntry.method);
            this.put16(this.ch, 12, 0);
            this.put16(this.ch, 14, 0);
            this.put32(this.ch, 16, (int)zipEntry.crc);
            this.put32(this.ch, 20, (int)zipEntry.csize);
            this.put32(this.ch, 24, (int)zipEntry.size);
            this.put16(this.ch, 28, zipEntry.name == null ? 0 : zipEntry.name.length());
            this.put16(this.ch, 30, zipEntry.extra == null ? 0 : zipEntry.extra.length);
            this.put16(this.ch, 32, zipEntry.comment == null ? 0 : zipEntry.comment.length());
            this.put16(this.ch, 34, 0);
            this.put16(this.ch, 36, 0);
            this.put32(this.ch, 38, 0);
            this.put32(this.ch, 42, (int)zipEntry.offset);
            this.strm.write(this.ch);
            this.strm.write(zipEntry.name.getBytes());
            ++n;
            n2 += 46 + zipEntry.name.length();
        }
        this.put32(this.ce, 0, 101010256);
        this.put16(this.ce, 4, 0);
        this.put16(this.ce, 6, 0);
        this.put16(this.ce, 8, n);
        this.put16(this.ce, 10, n);
        this.put32(this.ce, 12, n2);
        this.put32(this.ce, 16, this.dout);
        this.put16(this.ce, 20, 0);
        this.strm.write(this.ce);
        this.dir = null;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.closeEntry();
        this.put32(this.lh, 0, 67324752);
        this.put16(this.lh, 4, 10);
        this.put16(this.lh, 6, zipEntry.flag);
        if (zipEntry.method == -1) {
            zipEntry.method = this.method;
        }
        if (zipEntry.method == 0) {
            if (zipEntry.size == -1L) {
                throw new ZipException("size not set in stored entry");
            }
            zipEntry.csize = zipEntry.size;
            if (zipEntry.crc == 0L) {
                throw new ZipException("crc not set in stored entry");
            }
        }
        if (this.curr == null || this.curr.method != zipEntry.method) {
            this.def = zipEntry.method == 0 ? new Storer() : new Deflater(this.level, true);
        }
        this.put16(this.lh, 8, zipEntry.method);
        this.put16(this.lh, 10, 0);
        this.put16(this.lh, 12, 0);
        this.put32(this.lh, 14, (int)zipEntry.crc);
        this.put32(this.lh, 18, zipEntry.csize == -1L ? 0 : (int)zipEntry.csize);
        this.put32(this.lh, 22, zipEntry.size == -1L ? 0 : (int)zipEntry.size);
        this.put16(this.lh, 26, zipEntry.name == null ? 0 : zipEntry.name.length());
        this.put16(this.lh, 28, zipEntry.extra == null ? 0 : zipEntry.extra.length);
        this.strm.write(this.lh);
        if (zipEntry.name != null) {
            this.strm.write(zipEntry.name.getBytes());
        }
        if (zipEntry.extra != null) {
            this.strm.write(zipEntry.extra);
        }
        zipEntry.offset = this.dout;
        this.dout += 30 + zipEntry.name.length();
        this.dir.addElement(zipEntry);
        this.curr = zipEntry;
    }

    public void setComment(String string) {
    }

    public void setLevel(int n) {
        if ((n < 0 || n > 9) && n != -1) {
            throw new IllegalArgumentException("bad compression level");
        }
        this.level = n;
    }

    public void setMethod(int n) {
        if (n != 8 && n != 0) {
            throw new IllegalArgumentException("bad compression method");
        }
        this.method = n;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    private void put16(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
    }

    private void put32(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
        byArray[n + 2] = (byte)(n2 >> 16);
        byArray[n + 3] = (byte)(n2 >> 24);
    }

    class Storer
    extends Deflater {
        private int total;
        private byte[] buf;
        private int off;
        private int len;

        Storer() {
        }

        public int deflate(byte[] byArray, int n, int n2) {
            if (n2 >= this.len) {
                n2 = this.len;
            }
            System.arraycopy(this.buf, this.off, byArray, n, n2);
            this.total += n2;
            this.off += n2;
            this.len -= n2;
            return n2;
        }

        public synchronized void setInput(byte[] byArray, int n, int n2) {
            this.buf = byArray;
            this.off = n;
            this.len = n2;
        }

        public boolean needsInput() {
            return this.len <= 0;
        }

        public boolean finished() {
            return this.len <= 0;
        }

        public int getTotalIn() {
            return this.total;
        }

        public int getTotalOut() {
            return this.total;
        }

        public void reset() {
        }
    }
}

