/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = -1.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 2.2250738585072014E-308;
    public static final Class TYPE = Class.getPrimitiveClass("double");
    private double value;

    public static native String toString(double var0);

    public static native Double valueOf(String var0) throws NumberFormatException;

    public static native long doubleToLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) throws NumberFormatException {
        this(Double.valueOf(string));
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return Double.toString(this);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Double) {
            Double d = (Double)object;
            if (this.isNaN() && d.isNaN()) {
                return true;
            }
            double d2 = this;
            double d3 = d;
            if (d2 == 0.0 && d3 == 0.0) {
                return false;
            }
            if (d2 == 0.0 && d3 == 0.0) {
                return false;
            }
            return d2 == d3;
        }
        return false;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int hashCode() {
        return this.intValue();
    }

    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return this == Double.POSITIVE_INFINITY || this == Double.NEGATIVE_INFINITY;
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public long longValue() {
        return (long)this.value;
    }
}

