/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;

    public DataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += n2;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.writeByte(1);
        } else {
            this.writeByte(0);
        }
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeBytes(String string) throws IOException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)(cArray[i] & 0xFF);
        }
        this.write(byArray, 0, byArray.length);
    }

    public final void writeChar(int n) throws IOException {
        this.writeByte((n & 0xFF00) >> 8);
        this.writeByte(n & 0xFF);
    }

    public final void writeChars(String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeInt(int n) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = 0;
        int n3 = 24;
        while (n2 < 4) {
            byArray[n2] = (byte)(0xFF & n >> n3);
            ++n2;
            n3 -= 8;
        }
        this.write(byArray, 0, 4);
    }

    public final void writeLong(long l) throws IOException {
        int n = (int)(l >> 32);
        int n2 = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        this.writeInt(n);
        this.writeInt(n2);
    }

    public final void writeShort(int n) throws IOException {
        this.writeChar(n);
    }

    public final void writeUTF(String string) throws IOException {
        char[] cArray = string.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                byteArrayOutputStream.write(c);
                continue;
            }
            if (c <= '\u07ff') {
                byteArrayOutputStream.write(0xC0 | 0x3F & c >> 6);
                byteArrayOutputStream.write(0x80 | 0x3F & c);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | 0xF & c >> 12);
            byteArrayOutputStream.write(0x80 | 0x3F & c >> 6);
            byteArrayOutputStream.write(0x80 | 0x3F & c);
        }
        cArray = null;
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 65535) {
            throw new UTFDataFormatException("String too long");
        }
        DataOutputStream dataOutputStream = this;
        synchronized (dataOutputStream) {
            try {
                this.writeShort(byArray.length);
                this.write(byArray, 0, byArray.length);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }
}

