/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;

public class Polygon
implements Shape {
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;

    public Polygon() {
        this.npoints = 0;
        this.xpoints = new int[5];
        this.ypoints = new int[5];
    }

    public Polygon(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        if (nArray2.length < n2) {
            n2 = nArray2.length;
        }
        if (n2 < n) {
            n = n2;
        }
        this.npoints = n;
        this.xpoints = new int[n];
        this.ypoints = new int[n];
        System.arraycopy(nArray, 0, this.xpoints, 0, n);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n);
    }

    public void addPoint(int n, int n2) {
        if (this.npoints == this.xpoints.length) {
            this.grow();
        }
        this.xpoints[this.npoints] = n;
        this.ypoints[this.npoints] = n2;
        ++this.npoints;
        if (this.bounds != null) {
            int n3;
            if (n < this.bounds.x) {
                this.bounds.x = n;
            }
            if ((n3 = n - this.bounds.x) > this.bounds.width) {
                this.bounds.width = n3;
            }
            if (n2 < this.bounds.y) {
                this.bounds.y = n2;
            }
            if ((n3 = n2 - this.bounds.y) > this.bounds.height) {
                this.bounds.height = n3;
            }
        }
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        int n3 = 0;
        if (this.bounds == null) {
            this.getBounds();
        }
        if (n < this.bounds.x || n2 < this.bounds.y || n > this.bounds.x + this.bounds.width || n2 > this.bounds.y + this.bounds.height) {
            return false;
        }
        int n4 = 0;
        int n5 = 1;
        while (n4 < this.npoints) {
            int n6;
            if (n5 == this.npoints) {
                n5 = 0;
            }
            int n7 = this.xpoints[n4];
            int n8 = this.xpoints[n5];
            int n9 = this.ypoints[n4];
            if (n9 > n2 != (n6 = this.ypoints[n5]) > n2 && n9 != n2 && (n7 >= n || n8 >= n)) {
                if (n8 == n7) {
                    ++n3;
                } else {
                    float f = (n6 - n9) / (n8 - n7);
                    if ((f * (float)n7 - (float)n9) / f > 0.0f) {
                        ++n3;
                    }
                }
            }
            ++n4;
            ++n5;
        }
        return n3 & true;
    }

    public Rectangle getBoundingBox() {
        return this.getBounds();
    }

    public Rectangle getBounds() {
        int n;
        int n2;
        if (this.bounds != null) {
            return this.bounds;
        }
        int n3 = n2 = Integer.MAX_VALUE;
        int n4 = n = Integer.MIN_VALUE;
        for (int i = 0; i < this.npoints; ++i) {
            int n5 = this.xpoints[i];
            int n6 = this.ypoints[i];
            if (n5 < n2) {
                n2 = n5;
            }
            if (n5 > n) {
                n = n5;
            }
            if (n6 < n3) {
                n3 = n6;
            }
            if (n6 <= n4) continue;
            n4 = n6;
        }
        this.bounds = new Rectangle(n2, n3, n - n2, n4 - n3);
        return this.bounds;
    }

    void grow() {
        int n = this.xpoints.length * 3 / 2;
        int[] nArray = new int[n];
        System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
        this.xpoints = nArray;
        nArray = new int[n];
        System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
        this.ypoints = nArray;
    }

    public boolean inside(int n, int n2) {
        return this.contains(n, n2);
    }

    public void translate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.npoints) {
            int n4 = n3;
            this.xpoints[n4] = this.xpoints[n4] + n;
            int n5 = n3++;
            this.ypoints[n5] = this.ypoints[n5] + n2;
        }
        if (this.bounds != null) {
            this.bounds.x += n;
            this.bounds.y += n2;
        }
    }
}

