# Full-on-robot-chubby partyline /whois and /who commands

# Usage: ./whois <nick> [,nick]

# Usage: ./who <channel>

# Written 2/22/97 by BillyJoe (billyjoe@prismnet.com)
#
#Fixed (26/7-97) by Per [dw] Johansson <email: dw@mindless.com>
#to work with eggdrop1.1.x bots!!



bind dcc o /whois do_dccwhois

bind dcc o /who do_dccwho



bind raw - "311" rpl_whoisuser

bind raw - "312" rpl_whoisserver

bind raw - "313" rpl_whoisoperator

bind raw - "315" rpl_endofwho

bind raw - "317" rpl_whoisidle

bind raw - "318" rpl_endofwhois

bind raw - "319" rpl_whoischannels

bind raw - "352" rpl_whoreply

bind raw - "401" err_nosuchnick


#create globals
set dcc_whois() ""
set dcc_who() ""


proc do_dccwhois {handle idx args} {

	global dcc_whois

	

	set whois [string tolower [lindex $args 0]]

	if {$whois == ""} {

		putdcc $idx "Usage: ./whois <nick> \[,nick\]"

	}



	foreach who [split $whois ,] {

		if {[info exists dcc_whois($who)]} {

			append dcc_whois($who) ",$handle"

		} else {

			set dcc_whois($who) $handle

		}

	}
		putserv "WHOIS $whois"

}



proc do_dccwho {handle idx args} {

	global dcc_who

	

	set who [string tolower [lindex $args 0]]

	if {$who == ""} {

		putdcc $idx "Usage: ./who <nick> \[,nick\]"

	}



	foreach who [split $who ,] {

		if {[info exists dcc_who($who)]} {

			append dcc_who($who) ",$handle"

		} else {

			set dcc_who($who) $handle

		}

	}

	putserv "WHO $who"

}



proc show_whois_info {who arg} {

	global dcc_whois



	if {[info exists dcc_whois($who)]} {

		foreach handle [split $dcc_whois($who) ,] {

			if {[hand2idx $handle] != -1} {

				putdcc [hand2idx $handle] "$arg"

			}

		}

	}

}



proc show_who_info {who arg} {

	global dcc_who



	if {[info exists dcc_who]} {

		foreach who2 [array names dcc_who] {

			if {[string match "*$who2*" $who]} {

				foreach handle [split $dcc_who($who2) ,] {

					if {[hand2idx $handle] != -1} {

						putdcc [hand2idx $handle] "$arg"

					}

				}

			}

		}

	}

}



proc err_nosuchnick {from key args} {

	global dcc_whois

	set args "$from $key [lindex $args 0]"

	set n [lindex $args 3] ; set ln [string tolower $n]

	show_whois_info $ln "$n No such nick/channel"

	catch {unset dcc_whois($ln)}

}



proc rpl_whoischannels {from key args} {

	set args "$from $key [lindex $args 0]"

	set n [lindex $args 3] ; set ln [string tolower $n]

	set chans [string trimleft [lrange $args 4 end] :]

	show_whois_info $ln "$n on $chans"
}

proc rpl_endofwhois {from key args} {
	global dcc_whois
	set args "$from $key [lindex $args 0]"
	foreach n [split [lindex $args 3] ,] {
	set ln [string tolower $n]
	show_whois_info $ln "$n End of /WHOIS"
	catch {unset dcc_whois($ln)}
	}
}


proc rpl_whoisidle {from key args} {

	set args "$from $key [lindex $args 0]"

	set n [lindex $args 3] ; set ln [string tolower $n]

	set s [lindex $args 4]

	set l [lindex $args 5]

	show_whois_info $ln "$n has been idle $s seconds, signed on [ctime $l]"

}



proc rpl_whoisoperator {from key args} {

	set args "$from $key [lindex $args 0]"

	set n [lindex $args 3] ; set ln [string tolower $n]

	set i [string trimleft [lrange $args 4 end] :]

	show_whois_info $ln "$n $i (is an IRCop)"

}



proc rpl_whoisserver {from key args} {

	set args "$from $key [lindex $args 0]"

	set n [lindex $args 3] ; set ln [string tolower $n]

	set s [lindex $args 4]

	set t [string trimleft [lrange $args 5 end] :]

	show_whois_info $ln "$n using $s $t"

}



proc rpl_whoisuser {from key args} {
	set args "$from $key [lindex $args 0]"

	set n [lindex $args 3] ; set ln [string tolower $n]

	set u [lindex $args 4]

	set h [lindex $args 5]

	set r [string trimleft [lrange $args 7 end] :]
	show_whois_info $ln "$n is $u@$h * $r"

}



proc rpl_whoreply {from key args} {

	set args "$from $key [lindex $args 0]"

	set who [lrange $args 3 end]

	set c [lindex $who 0]

	set uh "[lindex $who 1]@[lindex $who 2]"

	set s [lindex $who 3]

	set n [lindex $who 4]

	set at [lindex $who 5]

	set r [lrange $who 7 end]

	show_who_info $who "$c $at $n ($uh) * $r"

}



proc rpl_endofwho {from key args} {

	global dcc_who

	set args "$from $key [lindex $args 0]"

	set who [lindex $args 3]

	show_who_info $who "[string trimleft [lrange $args 4 end] :]"

	catch {unset dcc_who($who)}
}
putlog "who's v.1.1.0 loaded.."
